package com.rawcritics.TyrOvC.OreObfuscationPlugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import net.minecraft.server.Packet51MapChunk;

import org.bukkit.craftbukkit.ChunkCompressionThread;
import org.bukkit.event.Event.Priority;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.PluginManager;


public class OreObfuscationPluginMain extends JavaPlugin {

	static final String pluginName = "OOE";
	static String version="OOE1.6";

	public final OreObfuscateBlockListener blockListener = new  OreObfuscateBlockListener(this);
	public final OreObfuscateEntityListener entityListener = new  OreObfuscateEntityListener(this);
	
	public static  OreObfuscationPluginMain oreobfuscationpluginbukkit;
	
    private File config;
    private String filename="oo-engine-mode.txt";
	
    //Config Defaults
    public int enginemode=4;
    public int oreupdateradius=2;
    public int oreupdatemode=0;
    public boolean checkexplosions=true;
    public boolean hidechests=true;
    public boolean checkplayerwhitelist=false;
    private byte[] defaultTransparentIds = {6,8,9,10,11,18,20,26,27,28,30,31,32,34,37,38,39,40,44,50,51,52,53,55,59,63,64,65,66,67,68,69,70,71,72,75,76,77,78,79,83,85,90,92,93,94,96};
    //Config Defaults End
    
    private byte[] transparentIds = {6,8,9,10,11,18,20,26,27,28,30,31,32,34,37,38,39,40,44,50,51,52,53,55,59,63,64,65,66,67,68,69,70,71,72,75,76,77,78,79,83,85,90,92,93,94,96};
    
	@Override
	public void onEnable() {

		
		PluginDescriptionFile pdfFile = this.getDescription();
		System.out.println(pdfFile.getName() + " " + pdfFile.getVersion()
				+ " plugin enabled");
		version = pdfFile.getVersion();
		
		File dir = getDataFolder();
		if (!dir.exists())
			dir.mkdir();
		config = new File(dir, filename);
    	if(config.exists()) {
    	    try {
    	    	  boolean transparentkeypresent=false;
    	    	  boolean oreradiuskeypresent=false;
    	    	  boolean oreupdatemodekeypresent=false;
    	    	  boolean checkexplosionskeypresent=false;
    	    	  boolean hidechestskeypresent=false;
    	    	  boolean checkplayerwhitelistkeypresent=false;
    		      BufferedReader localBufferedReader = new BufferedReader(new FileReader(this.config));
    		      String str = "";
    		      while ((str = localBufferedReader.readLine()) != null) {
    		    	  if(str.charAt(0)=='#')continue;
    		    	  String[] keypair=str.split("=");
    		    	  if(keypair[0].equalsIgnoreCase("enginemode")){
    		    		 try{
    		    		  enginemode=Integer.parseInt(keypair[1]);
    		    		  if(enginemode!=1 && enginemode!=2 && enginemode!=3 && enginemode!=4  && enginemode!=5)throw new NumberFormatException();
    		    		  	if(enginemode==3){
    		    		  		System.out.println(pdfFile.getName() + " Mode 3 is deprecated, use Mode 1 and set hidechests=false!");
    		    		  		enginemode=1;hidechests=false;
    		    		  	}
    		    		 }
    		    		 catch(NumberFormatException e){
    		    			 System.out.println(pdfFile.getName() + " config file is invalid. Engine mode must be 1 or 2 or 3 or 4 or 5 (4 default)!");
    		    			 enginemode=4;
    		    		 }
    		    	  }
    		    	  if(keypair[0].equalsIgnoreCase("transparentIds")){
     		    		 transparentkeypresent=true;
    		    		  try{
     		    			String[] transparentconfigids=keypair[1].split(",");
     		    				this.transparentIds=new byte[transparentconfigids.length];
     		    			for(int index=0;index<transparentconfigids.length;index++){
     		    				this.transparentIds[index]=Byte.parseByte(transparentconfigids[index]);
     		    			}
     		    			java.util.Arrays.sort(this.transparentIds);
     		    		 }
     		    		 catch(NumberFormatException e){
     		    			 System.out.println(pdfFile.getName() + " config file is invalid. The transparent ids setting is not formated correctly.");
     		    			 Packet51MapChunk.transparentIds=new byte[this.defaultTransparentIds.length];
     		    			 System.arraycopy(this.defaultTransparentIds, 0, Packet51MapChunk.transparentIds, 0, this.defaultTransparentIds.length);
     		    		 }
     		    	  }
    		    	  if(keypair[0].equalsIgnoreCase("oreupdateradius")){
    		    		 oreradiuskeypresent=true;
     		    		 try{
     		    		  oreupdateradius=Integer.parseInt(keypair[1]);
     		    		  if(oreupdateradius<1 || oreupdateradius>127)throw new NumberFormatException();
     		    		 }
     		    		 catch(NumberFormatException e){
     		    			 System.out.println(pdfFile.getName() + " config file is invalid. Ore update radius must be a number between 1 and 127 (2 default)!");
     		    			 oreupdateradius=2;
     		    		 }
     		    	  }
    		    	  if(keypair[0].equalsIgnoreCase("oreupdatemode")){
     		    		 oreupdatemodekeypresent=true;
      		    		 try{
      		    		  oreupdatemode=Integer.parseInt(keypair[1]);
      		    		  if(oreupdatemode!=0 && oreupdatemode!=1)throw new NumberFormatException();
      		    		 }
      		    		 catch(NumberFormatException e){
      		    			 System.out.println(pdfFile.getName() + " config file is invalid. Ore update mode must be 0 or 1!");
      		    			 oreupdatemode=0;
      		    		 }
      		    	  }
    		    	  if(keypair[0].equalsIgnoreCase("checkexplosions")){
    		    		  checkexplosionskeypresent=true;
      		    		  checkexplosions=Boolean.parseBoolean(keypair[1]);
      		    	  }
    		    	  if(keypair[0].equalsIgnoreCase("hidechests")){
    		    		  hidechestskeypresent=true;
      		    		  hidechests=Boolean.parseBoolean(keypair[1]);
      		    	  }
    		    	  if(keypair[0].equalsIgnoreCase("checkplayerwhitelist")){
    		    		  checkplayerwhitelistkeypresent=true;
      		    		  checkplayerwhitelist=Boolean.parseBoolean(keypair[1]);
      		    	  }
    		      }
    		      localBufferedReader.close();
    		      if(transparentkeypresent==false){
    		    	  PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, true));
    		    	  localPrintWriter.println();
    			      localPrintWriter.println("#List of block ids to count as transparent, seperated by commas.");
    			      localPrintWriter.println("transparentIds=6,8,9,10,11,18,20,26,27,28,30,31,32,34,37,38,39,40,44,50,51,52,53,55,59,63,64,65,66,67,68,69,70,71,72,75,76,77,78,79,83,85,90,92,93,94,96");
    			      localPrintWriter.close();
    		      }
    		      if(oreradiuskeypresent==false){
    		    	  PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, true));
    		    	  localPrintWriter.println();
    		    	  localPrintWriter.println("#Radius around removed blocks that block updates are sent for ores. Higher values use more processing power and bandwith but are nicer for players with bad connections. Default 2, recommended no higher then 4.");
			          localPrintWriter.println("oreupdateradius=2");
    			      localPrintWriter.close();
    		      }
    		      if(oreupdatemodekeypresent==false){
    		    	  PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, true));
    		    	  localPrintWriter.println();
    		    	  localPrintWriter.println("#When to send player ore updates. 0 (default) is on block break events. 1 is on block damage, which can make latency slightly less noticable, but uses more proccessing power in the main server thread.");
    		    	  localPrintWriter.println("oreupdatemode=0");
    			      localPrintWriter.close();
    		      }
    		      if(checkexplosionskeypresent==false){
    		    	  PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, true));
    		    	  localPrintWriter.println();
    		    	  localPrintWriter.println("#Checks for exposed ores after explosions if true. If you have a plugin for disabling block damage from creepers, depending on how the plugin is written in might save processing power to disable this.");
			          localPrintWriter.println("checkexplosions=true");
    			      localPrintWriter.close();
    		      }
    		      if(hidechestskeypresent==false){
    		    	  PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, true));
    		    	  localPrintWriter.println();
  			          localPrintWriter.println("#Hides chests in all engine modes by turning chests without adjacent transparent blocks into stone until uncovered.");
  			          localPrintWriter.println("hidechests=true");
    			      localPrintWriter.close();
    		      }
    		      if(checkplayerwhitelistkeypresent==false){
    		    	  PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, true));
    		    	  localPrintWriter.println();
  			          localPrintWriter.println("#If true, players with the 'oreobfuscater.disabledfor' will not have chunks obfuscated before they are sent.");
  			          localPrintWriter.println("checkplayerwhitelist=false");
    			      localPrintWriter.close();
    		      }
    		    } catch (Exception localException) {
    		    	System.out.println("[WARNING]"+pdfFile.getName()+"Failed to load engine config, defaulting to type 1");
    		    }
    	} else {
    		try {
    			config.createNewFile();
    		    try {
    			      PrintWriter localPrintWriter = new PrintWriter(new FileWriter(this.config, false));
    			        localPrintWriter.println("#Choose the obfuscation engine you want to run.");
    			        localPrintWriter.println("#1 Hides all ores and chests that don't have a transparent block next to them.");
    			        localPrintWriter.println("#2 Hides all ores regardless of whether they have a transparent block next to them, and hides chests that don't have a transparent block beside them. Ores reappear when dug, or when they are right clicked on.");
    			        localPrintWriter.println("#3 (Deprecated, do not use! Instead, Mode 1 and Hide Chests False) Same as Mode 1, but leaves chests alone. Might use if Lockette, etc. is already protecting chests.");
    			        localPrintWriter.println("#4 (default) Turns all stone AND ores without adjacent transparent blocks into iron ore above height 20, and diamond ore below. Turns chests without adjacent adjacent transparent blocks to stone.");
    			        localPrintWriter.println("#5 Randomly turns stone without adjacent transparent blocks into Ore. Slighly more process intensive then 4.");
    			        localPrintWriter.println("enginemode=4");
    			        localPrintWriter.println("#List of block ids to count as transparent, seperated by commas.");
    			        localPrintWriter.println("transparentIds=6,8,9,10,11,18,20,26,27,28,30,31,32,34,37,38,39,40,44,50,51,52,53,55,59,63,64,65,66,67,68,69,70,71,72,75,76,77,78,79,83,85,90,92,93,94,96");
    			        localPrintWriter.println("#Radius around removed blocks that block updates are sent for ores. Higher values use more processing power and bandwith but are nicer for players with bad connections. Default 2, recommended no higher then 4.");
    			        localPrintWriter.println("oreupdateradius=2");
    			        localPrintWriter.println("#When to send player ore updates. 0 (default) is on block break events. 1 is on block damage, which can make latency slightly less noticable, but uses more proccessing power in the main server thread.");
    			        localPrintWriter.println("oreupdatemode=0");
    			        localPrintWriter.println("#Checks for exposed ores after explosions if true. If you have a plugin for disabling block damage from creepers, depending on how the plugin is written in might save processing power to disable this.");
    			        localPrintWriter.println("checkexplosions=true");
    			        localPrintWriter.println("#Hides chests in all engine modes by turning chests without adjacent transparent blocks into stone until uncovered.");
    			        localPrintWriter.println("hidechests=true");
    			        localPrintWriter.close();
    			    } catch (Exception localException) {
        		    	System.out.println("[WARNING]"+pdfFile.getName()+" Failed to create default config.");
    			  }
    		} catch (IOException e) {
    		}
    		System.out.println(pdfFile.getName()+" Wrote default config.");
    	}
		
		oreobfuscationpluginbukkit=this;
		
		PluginManager pm = getServer().getPluginManager();
		if(oreupdatemode==0)
			pm.registerEvent(Event.Type.BLOCK_BREAK, blockListener, Priority.Monitor, this);
		if(oreupdatemode==1)
			pm.registerEvent(Event.Type.BLOCK_DAMAGE, blockListener, Priority.Monitor, this);
		if(checkexplosions)
			pm.registerEvent(Event.Type.ENTITY_EXPLODE, entityListener, Priority.Monitor, this);

		//1 is normal, 2 and greater is running. Add 1 to engine mode to find type
		try{
			if(Packet51MapChunk.OreObfusicationEngine!=1 && Packet51MapChunk.OreObfusicationEngine<2){
				System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine, Generic");
			}
			else{
				if(Packet51MapChunk.OreObfusicationEngine==1){
					Packet51MapChunk.OreObfusicationEngine=enginemode+1;
					//Packet51MapChunk.craftbukkitserver=(CraftServer) this.getServer();
					System.out.println(pdfFile.getName() + " connected to the Ore Obfuscate Engine and turned it on! Using Engine: "+enginemode);
						//Change specific things for each engine here
					if(enginemode==4){this.blockListener.enginespecificcheck=1;this.entityListener.enginespecificcheck=1;}
					if(enginemode==5){this.blockListener.enginespecificcheck=1;this.entityListener.enginespecificcheck=1;}
				}
				else if(Packet51MapChunk.OreObfusicationEngine>=2){
						System.out.println(pdfFile.getName() + " connected, Ore Obfuscate Engine was already on!");
				}
				Packet51MapChunk.transparentIds=new byte[this.transparentIds.length];
				System.arraycopy(this.transparentIds, 0, Packet51MapChunk.transparentIds, 0, this.transparentIds.length);
				Packet51MapChunk.runchestlogic=hidechests;
				ChunkCompressionThread.checkplayerwhitelist=checkplayerwhitelist;
			}
		}catch(java.lang.NoSuchFieldError e){
			System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine:");
			System.out.println("Ore Obufuscate Engine is not installed, please add the required class to the server jar");
		}
		catch(Exception e){
			System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine:");
			e.printStackTrace();
		}
		catch(Error e){
			System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine:");
			e.printStackTrace();
		}
	}

	@Override
	public void onDisable() {
		PluginDescriptionFile pdfFile = this.getDescription();
		
		try{
			Packet51MapChunk.OreObfusicationEngine=1;
			System.out.println(pdfFile.getName() + " connected to the Ore Obfuscate Engine and turned it off!");
		}catch(java.lang.NoSuchFieldError e){
			System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine:");
			System.out.println("Ore Obufuscate Engine is not installed, please add the required class to the server jar");
		}
		catch(Exception e){
			System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine:");
			e.printStackTrace();
		}
		catch(Error e){
			System.out.println("[SEVERE] Ore Obfuscation Plugin Cannot Attach To The Engine:");
			e.printStackTrace();
		}
		
		System.out.println("OreObfuscate Plugin Disabled");
		
	}
}