/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.common.NBTBase;
import net.minecraft.common.NBTTagCompound;

public class CompressedStreamTools {
    public static NBTTagCompound readCompressed(InputStream par0InputStream) throws IOException {
        NBTTagCompound var2;
        try (DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(par0InputStream)));){
            var2 = CompressedStreamTools.read(var1);
        }
        return var2;
    }

    public static void writeCompressed(NBTTagCompound par0NBTTagCompound, OutputStream par1OutputStream) throws IOException {
        try (DataOutputStream var2 = new DataOutputStream(new GZIPOutputStream(par1OutputStream));){
            CompressedStreamTools.write(par0NBTTagCompound, var2);
        }
    }

    public static NBTTagCompound decompress(byte[] par0ArrayOfByte) throws IOException {
        NBTTagCompound var2;
        try (DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(par0ArrayOfByte))));){
            var2 = CompressedStreamTools.read(var1);
        }
        return var2;
    }

    public static byte[] compress(NBTTagCompound par0NBTTagCompound) throws IOException {
        ByteArrayOutputStream var1 = new ByteArrayOutputStream();
        try (DataOutputStream var2 = new DataOutputStream(new GZIPOutputStream(var1));){
            CompressedStreamTools.write(par0NBTTagCompound, var2);
        }
        return var1.toByteArray();
    }

    public static void safeWrite(NBTTagCompound par0NBTTagCompound, File par1File) throws IOException {
        File var2 = new File(String.valueOf(par1File.getAbsolutePath()) + "_tmp");
        if (var2.exists()) {
            var2.delete();
        }
        CompressedStreamTools.write(par0NBTTagCompound, var2);
        if (par1File.exists()) {
            par1File.delete();
        }
        if (par1File.exists()) {
            throw new IOException("Failed to delete " + par1File);
        }
        var2.renameTo(par1File);
    }

    private static void write(NBTTagCompound par0NBTTagCompound, File par1File) throws IOException {
        try (DataOutputStream var2 = new DataOutputStream(new FileOutputStream(par1File));){
            CompressedStreamTools.write(par0NBTTagCompound, var2);
        }
    }

    public static NBTTagCompound read(File par0File) throws IOException {
        NBTTagCompound var2;
        if (!par0File.exists()) {
            return null;
        }
        try (DataInputStream var1 = new DataInputStream(new FileInputStream(par0File));){
            var2 = CompressedStreamTools.read(var1);
        }
        return var2;
    }

    public static NBTTagCompound read(DataInput par0DataInput) throws IOException {
        NBTBase var1 = NBTBase.readNamedTag(par0DataInput);
        if (var1 instanceof NBTTagCompound) {
            return (NBTTagCompound)var1;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound par0NBTTagCompound, DataOutput par1DataOutput) throws IOException {
        NBTBase.writeNamedTag(par0NBTTagCompound, par1DataOutput);
    }
}

