/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Rule;
import org.apache.commons.lang3.text.StrSubstitutor;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class Library {
    protected static final String FORGE_LIB_SUFFIX = ".pack.xz";
    protected static final StrSubstitutor SUBSTITUTOR;
    protected String name;
    protected List<Rule> rules;
    protected Map<OS, String> natives;
    protected ExtractRules extract;
    protected String url;
    protected String exact_url;
    protected String packed;
    protected String checksum;
    protected List<String> deleteEntries;

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("platform", OS.CURRENT.getName());
        map.put("arch", OS.Arch.CURRENT.asString());
        SUBSTITUTOR = new StrSubstitutor(map);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Library)) {
            return false;
        }
        Library lib = (Library)o;
        return this.name == null ? lib.name == null : this.name.equalsIgnoreCase(lib.name);
    }

    public String getName() {
        return this.name;
    }

    public String getPlainName() {
        String[] split = this.name.split(":", 3);
        return String.valueOf(split[0]) + "." + split[1];
    }

    public List<Rule> getRules() {
        return this.rules == null ? null : Collections.unmodifiableList(this.rules);
    }

    public boolean appliesToCurrentEnvironment() {
        if (this.rules == null) {
            return true;
        }
        Rule.Action lastAction = Rule.Action.DISALLOW;
        for (Rule rule : this.rules) {
            Rule.Action action = rule.getAppliedAction();
            if (action == null) continue;
            lastAction = action;
        }
        return lastAction == Rule.Action.ALLOW;
    }

    public Map<OS, String> getNatives() {
        return this.natives;
    }

    public ExtractRules getExtractRules() {
        return this.extract;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public List<String> getDeleteEntriesList() {
        return this.deleteEntries;
    }

    String getArtifactBaseDir() {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact dir of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 3);
        return String.format("%s/%s/%s", parts[0].replaceAll("\\.", "/"), parts[1], parts[2]);
    }

    public String getArtifactPath() {
        return this.getArtifactPath(null);
    }

    public String getArtifactPath(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact path of empty/blank artifact");
        }
        return String.format("%s/%s", this.getArtifactBaseDir(), this.getArtifactFilename(classifier));
    }

    String getArtifactFilename(String classifier) {
        if (this.name == null) {
            throw new IllegalStateException("Cannot get artifact filename of empty/blank artifact");
        }
        String[] parts = this.name.split(":", 3);
        String result = classifier == null ? String.format("%s-%s.jar", parts[1], parts[2]) : String.format("%s-%s%s.jar", parts[1], parts[2], "-" + classifier);
        return SUBSTITUTOR.replace(result);
    }

    public String toString() {
        return "Library{name='" + this.name + '\'' + ", rules=" + this.rules + ", natives=" + this.natives + ", extract=" + this.extract + ", packed='" + this.packed + "'}";
    }

    public Downloadable getDownloadable(Repository versionSource, File file, OS os) {
        String path;
        Repository repo = null;
        boolean isForge = "forge".equals(this.packed);
        if (this.exact_url == null) {
            String nativePath = this.natives != null && this.appliesToCurrentEnvironment() ? this.natives.get((Object)os) : null;
            path = String.valueOf(this.getArtifactPath(nativePath)) + (isForge ? FORGE_LIB_SUFFIX : "");
            if (this.url == null) {
                repo = Repository.LIBRARY_REPO;
            } else if (this.url.startsWith("/")) {
                repo = versionSource;
                path = String.valueOf(this.url.substring(1)) + path;
            } else {
                path = String.valueOf(this.url) + path;
            }
        } else {
            path = this.exact_url;
        }
        if (isForge) {
            File tempFile = new File(String.valueOf(file.getAbsolutePath()) + FORGE_LIB_SUFFIX);
            return new ForgeLibDownloadable(path, tempFile, file);
        }
        return repo == null ? new LibraryDownloadable(path, file, null, null) : new LibraryDownloadable(repo, path, file);
    }

    /*
     * Exception decompiling
     */
    private static synchronized void unpackLibrary(File library, File output, boolean retryOnOutOfMemory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static synchronized void unpackLibrary(File library, File output) throws IOException {
        Library.unpackLibrary(library, output, true);
    }

    private static void close(Closeable ... closeables) {
        Closeable[] closeableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable c = closeableArray[n2];
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    private static void forgeLibLog(Object ... o) {
        U.log("[ForgeLibDownloadable]", o);
    }

    public class ForgeLibDownloadable
    extends LibraryDownloadable {
        private final File unpacked;

        public ForgeLibDownloadable(String url, File packedLib, File unpackedLib) {
            super(url, packedLib);
            this.unpacked = unpackedLib;
        }

        @Override
        protected void onComplete() throws RetryDownloadException {
            super.onComplete();
            try {
                Library.unpackLibrary(this.getDestination(), this.unpacked);
            }
            catch (Throwable t) {
                throw new RetryDownloadException("cannot unpack forge library", t);
            }
        }
    }

    public class LibraryDownloadable
    extends Downloadable {
        private LibraryDownloadable(Repository repo, String path, File file) {
            super(repo, path, file);
        }

        private LibraryDownloadable(String path, File file) {
            super(path, file);
        }

        public Library getDownloadableLibrary() {
            return Library.this;
        }

        public Library getLibrary() {
            return Library.this;
        }

        /* synthetic */ LibraryDownloadable(String string, File file, LibraryDownloadable libraryDownloadable, LibraryDownloadable libraryDownloadable2) {
            this(string, file);
        }
    }
}

