/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import joptsimple.OptionSet;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.configuration.ArgumentParser;
import ru.turikhay.tlauncher.configuration.ConfigurationDefaults;
import ru.turikhay.tlauncher.configuration.PlainParser;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncher;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.Direction;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.U;

public class Configuration
extends SimpleConfiguration {
    private ConfigurationDefaults defaults;
    private Map<String, Object> constants;
    private List<Locale> defaultLocales;
    private List<Locale> supportedLocales;
    private boolean firstRun;

    private Configuration(URL url, OptionSet set) throws IOException {
        super(url);
        this.init(set);
    }

    private Configuration(File file, OptionSet set) {
        super(file);
        this.init(set);
    }

    public static Configuration createConfiguration(OptionSet set) throws IOException {
        boolean doesntExist;
        File file;
        Object path;
        Object object = path = set != null ? set.valueOf("settings") : null;
        if (path == null) {
            file = FileUtil.getNeighborFile("tlauncher.cfg");
            if (!file.isFile()) {
                file = FileUtil.getNeighborFile("tlauncher.properties");
            }
            if (!file.isFile()) {
                file = MinecraftUtil.getSystemRelatedDirectory(TLauncher.getSettingsFile());
            }
        } else {
            file = new File(path.toString());
        }
        boolean bl = doesntExist = !file.isFile();
        if (doesntExist) {
            U.log("Creating configuration file...");
            FileUtil.createFile(file);
        }
        U.log("Loading configuration from file:", file);
        Configuration config = new Configuration(file, set);
        config.firstRun = doesntExist;
        return config;
    }

    public static Configuration createConfiguration() throws IOException {
        return Configuration.createConfiguration(null);
    }

    private void init(OptionSet set) {
        this.comments = " TLauncher configuration file\n Created in " + TLauncher.getBrand() + " " + TLauncher.getVersion();
        this.defaults = new ConfigurationDefaults();
        this.constants = ArgumentParser.parse(set);
        this.set(this.constants, false);
        this.log("Constant values:", this.constants);
        int version = ConfigurationDefaults.getVersion();
        if (this.getDouble("settings.version") != (double)version) {
            this.clear();
        }
        this.set("settings.version", version, false);
        for (Map.Entry<String, Object> curen : this.defaults.getMap().entrySet()) {
            String key = curen.getKey();
            if (this.constants.containsKey(key)) {
                this.log("Key \"" + key + "\" is unsaveable!");
                continue;
            }
            String value = this.get(key);
            Object defvalue = curen.getValue();
            if (defvalue == null) continue;
            try {
                PlainParser.parse(value, defvalue);
            }
            catch (Exception e) {
                this.log("Key \"" + key + "\" is invalid!", e);
                this.set(key, defvalue, false);
            }
        }
        this.defaultLocales = Configuration.getDefaultLocales();
        this.supportedLocales = this.getSupportedLocales();
        Locale selected = Configuration.getLocaleOf(this.get("locale"));
        if (selected == null) {
            this.log("Selected locale is not supported, rolling back to default one");
            selected = Locale.getDefault();
            if (selected == Configuration.getLocaleOf("uk_UA")) {
                selected = Configuration.getLocaleOf("ru_RU");
            }
        }
        if (!this.supportedLocales.contains(selected)) {
            this.log("Default locale is not supported, rolling back to global default one");
            selected = Locale.US;
        }
        this.set("locale", selected, false);
        if (this.isSaveable()) {
            try {
                this.save();
            }
            catch (IOException e) {
                this.log("Cannot save value!", e);
            }
        }
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public boolean isSaveable(String key) {
        return !this.constants.containsKey(key);
    }

    public Locale getLocale() {
        return Configuration.getLocaleOf(this.get("locale"));
    }

    public boolean isUSSRLocale() {
        String locale = this.get("locale");
        return "ru_RU".equals(locale) || "uk_UA".equals(locale);
    }

    public Locale[] getLocales() {
        Locale[] locales = new Locale[this.supportedLocales.size()];
        return this.supportedLocales.toArray(locales);
    }

    public ActionOnLaunch getActionOnLaunch() {
        return ActionOnLaunch.get(this.get("minecraft.onlaunch"));
    }

    public ConsoleType getConsoleType() {
        return ConsoleType.get(this.get("gui.console"));
    }

    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.get(this.get("connection"));
    }

    public int[] getClientWindowSize() {
        String plainValue = this.get("minecraft.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getLauncherWindowSize() {
        String plainValue = this.get("gui.size");
        int[] value = new int[2];
        if (plainValue == null) {
            return new int[2];
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(plainValue);
            value[0] = arr.get(0);
            value[1] = arr.get(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public int[] getDefaultClientWindowSize() {
        String plainValue = this.getDefault("minecraft.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public int[] getDefaultLauncherWindowSize() {
        String plainValue = this.getDefault("gui.size");
        return IntegerArray.parseIntegerArray(plainValue).toArray();
    }

    public VersionFilter getVersionFilter() {
        VersionFilter filter = new VersionFilter();
        for (ReleaseType releaseType : ReleaseType.getDefinable()) {
            boolean include = this.getBoolean("minecraft.versions." + (Object)((Object)releaseType));
            if (include) continue;
            filter.exclude(releaseType);
        }
        ReleaseType.SubType[] subTypeArray = ReleaseType.SubType.values();
        int n = subTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReleaseType.SubType subType = subTypeArray[n2];
            boolean include = this.getBoolean("minecraft.versions.sub." + (Object)((Object)subType));
            if (!include) {
                filter.exclude(subType);
            }
            ++n2;
        }
        return filter;
    }

    public Direction getDirection(String key) {
        return Reflect.parseEnum(Direction.class, this.get(key));
    }

    public Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public UUID getClient() {
        try {
            return UUID.fromString(this.get("client"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getDefault(String key) {
        return this.getStringOf(this.defaults.get(key));
    }

    @Override
    public int getDefaultInteger(String key) {
        return this.getIntegerOf(this.defaults.get(key), 0);
    }

    @Override
    public double getDefaultDouble(String key) {
        return this.getDoubleOf(this.defaults.get(key), 0.0);
    }

    @Override
    public float getDefaultFloat(String key) {
        return this.getFloatOf(this.defaults.get(key), 0.0f);
    }

    @Override
    public long getDefaultLong(String key) {
        return this.getLongOf(this.defaults.get(key), 0L);
    }

    @Override
    public boolean getDefaultBoolean(String key) {
        return this.getBooleanOf(this.defaults.get(key), false);
    }

    @Override
    public void set(String key, Object value, boolean flush) {
        if (this.constants.containsKey(key)) {
            return;
        }
        super.set(key, value, flush);
    }

    public void setForcefully(String key, Object value, boolean flush) {
        super.set(key, value, flush);
    }

    public void setForcefully(String key, Object value) {
        this.setForcefully(key, value, true);
    }

    @Override
    public void save() throws IOException {
        if (!this.isSaveable()) {
            throw new UnsupportedOperationException();
        }
        Properties temp = Configuration.copyProperties(this.properties);
        for (String key : this.constants.keySet()) {
            temp.remove(key);
        }
        File file = (File)this.input;
        temp.store(new FileOutputStream(file), this.comments);
    }

    public File getFile() {
        if (!this.isSaveable()) {
            return null;
        }
        return (File)this.input;
    }

    private List<Locale> getSupportedLocales() {
        this.log("Searching for supported locales...");
        Pattern lang_pattern = Pattern.compile("lang/([\\w]+)$");
        File file = FileUtil.getRunningJar();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        try {
            ZipEntry e;
            URL jar = file.toURI().toURL();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((e = zip.getNextEntry()) != null) {
                String name = e.getName();
                Matcher mt = lang_pattern.matcher(name);
                if (!mt.matches()) continue;
                this.log("Found locale:", mt.group(1));
                locales.add(Configuration.getLocaleOf(mt.group(1)));
            }
        }
        catch (Exception e) {
            this.log("Cannot get locales!", e);
            return this.defaultLocales;
        }
        if (locales.isEmpty()) {
            return this.defaultLocales;
        }
        return locales;
    }

    private static List<Locale> getDefaultLocales() {
        ArrayList<Locale> l = new ArrayList<Locale>();
        l.add(Configuration.getLocaleOf("en_US"));
        l.add(Configuration.getLocaleOf("ru_RU"));
        l.add(Configuration.getLocaleOf("uk_UA"));
        return l;
    }

    public static Locale getLocaleOf(String locale) {
        if (locale == null) {
            return null;
        }
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale cur = localeArray[n2];
            if (cur.toString().equals(locale)) {
                return cur;
            }
            ++n2;
        }
        return null;
    }

    public static enum ActionOnLaunch {
        HIDE,
        EXIT,
        NOTHING;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            ActionOnLaunch[] actionOnLaunchArray = ActionOnLaunch.values();
            int n = actionOnLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionOnLaunch cur = actionOnLaunchArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static ActionOnLaunch get(String val) {
            ActionOnLaunch[] actionOnLaunchArray = ActionOnLaunch.values();
            int n = actionOnLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionOnLaunch cur = actionOnLaunchArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return cur;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ActionOnLaunch getDefault() {
            return HIDE;
        }
    }

    public static enum ConnectionQuality {
        GOOD(2, 5, 6, 15000),
        NORMAL(5, 10, 3, 45000),
        BAD(10, 20, 1, 120000);

        private final int minTries;
        private final int maxTries;
        private final int maxThreads;
        private final int timeout;
        private final int[] configuration;

        private ConnectionQuality(int minTries, int maxTries, int maxThreads, int timeout) {
            this.minTries = minTries;
            this.maxTries = maxTries;
            this.maxThreads = maxThreads;
            this.timeout = timeout;
            this.configuration = new int[]{minTries, maxTries, maxThreads};
        }

        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            ConnectionQuality[] connectionQualityArray = ConnectionQuality.values();
            int n = connectionQualityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionQuality cur = connectionQualityArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static ConnectionQuality get(String val) {
            ConnectionQuality[] connectionQualityArray = ConnectionQuality.values();
            int n = connectionQualityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConnectionQuality cur = connectionQualityArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return cur;
                }
                ++n2;
            }
            return null;
        }

        public int[] getConfiguration() {
            return this.configuration;
        }

        public int getMinTries() {
            return this.minTries;
        }

        public int getMaxTries() {
            return this.maxTries;
        }

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public int getTries(boolean fast) {
            return fast ? this.minTries : this.maxTries;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ConnectionQuality getDefault() {
            return GOOD;
        }
    }

    public static enum ConsoleType {
        GLOBAL,
        MINECRAFT,
        NONE;


        public static boolean parse(String val) {
            if (val == null) {
                return false;
            }
            ConsoleType[] consoleTypeArray = ConsoleType.values();
            int n = consoleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleType cur = consoleTypeArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static ConsoleType get(String val) {
            ConsoleType[] consoleTypeArray = ConsoleType.values();
            int n = consoleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleType cur = consoleTypeArray[n2];
                if (cur.toString().equalsIgnoreCase(val)) {
                    return cur;
                }
                ++n2;
            }
            return null;
        }

        public MinecraftLauncher.ConsoleVisibility getVisibility() {
            return this == GLOBAL ? MinecraftLauncher.ConsoleVisibility.NONE : (this == MINECRAFT ? MinecraftLauncher.ConsoleVisibility.ALWAYS : MinecraftLauncher.ConsoleVisibility.ON_CRASH);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static ConsoleType getDefault() {
            return NONE;
        }
    }
}

