/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.common.CompressedStreamTools;
import net.minecraft.common.NBTTagCompound;
import net.minecraft.common.NBTTagList;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.exceptions.ParseException;

public class ServerList {
    private List<Server> list = new ArrayList<Server>();

    public void add(Server server) {
        if (server == null) {
            throw new NullPointerException();
        }
        this.list.add(server);
    }

    public boolean remove(Server server) {
        if (server == null) {
            throw new NullPointerException();
        }
        return this.list.remove(server);
    }

    public boolean contains(Server server) {
        return this.list.contains(server);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<Server> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public void save(File file) throws IOException {
        NBTTagList servers = new NBTTagList();
        for (Server server : this.list) {
            servers.appendTag(server.getNBT());
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("servers", servers);
        CompressedStreamTools.safeWrite(compound, file);
    }

    public String toString() {
        return "ServerList{" + this.list.toString() + "}";
    }

    public static ServerList loadFromFile(File file) throws IOException {
        ServerList serverList = new ServerList();
        List<Server> list = serverList.list;
        NBTTagCompound compound = CompressedStreamTools.read(file);
        if (compound == null) {
            return serverList;
        }
        NBTTagList servers = compound.getTagList("servers");
        int i = 0;
        while (i < servers.tagCount()) {
            list.add(Server.loadFromNBT((NBTTagCompound)servers.tagAt(i)));
            ++i;
        }
        return serverList;
    }

    public static ServerList sortLists(ServerList pref, ServerList add) {
        ServerList serverList = new ServerList();
        List<Server> list = serverList.list;
        List<Server> prefList = pref.list;
        List<Server> addList = add.list;
        serverList.list.addAll(prefList);
        for (Server server : addList) {
            if (list.contains(server)) continue;
            list.add(server);
        }
        return serverList;
    }

    private static String[] splitAddress(String address) {
        String[] array = StringUtils.split(address, ':');
        switch (array.length) {
            case 1: {
                String[] stringArray = new String[2];
                stringArray[0] = address;
                return stringArray;
            }
            case 2: {
                return new String[]{array[0], array[1]};
            }
        }
        throw new ParseException("split incorrectly");
    }

    private static String validateNotBlank(String s, String name) throws ParseException {
        if (StringUtils.isBlank(s)) {
            throw new ParseException(String.valueOf(name) + " is blank");
        }
        return s;
    }

    public static class Server {
        private String name;
        private List<String> versions = new ArrayList<String>();
        private String ip;
        private String port;
        private String address;
        private boolean hideAddress;
        private int acceptTextures;
        private static Gson gson;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getVersions() {
            return Collections.unmodifiableList(this.versions);
        }

        public void addVersion(String version) {
            this.versions.add(version);
        }

        public void removeVersion(String version) {
            this.versions.remove(version);
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
            this.updateAddress();
        }

        public String getPort() {
            return this.port;
        }

        public void setPort(String port) {
            this.port = port;
            this.updateAddress();
        }

        private void updateAddress() {
            this.address = String.valueOf(this.ip) + (this.port == null ? "" : ":" + this.port);
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            if (address == null) {
                this.ip = null;
                this.port = null;
            } else {
                String[] split = ServerList.splitAddress(address);
                this.ip = split[0];
                this.port = split[1];
            }
            this.address = address;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Server)) {
                return false;
            }
            Server server = (Server)obj;
            return server.getAddress().equals(this.getAddress());
        }

        public String toString() {
            return "{'" + this.name + "', '" + this.address + "', " + this.versions + "}";
        }

        public NBTTagCompound getNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.setString("name", this.name);
            compound.setString("ip", this.address);
            compound.setBoolean("hideAddress", this.hideAddress);
            if (this.acceptTextures != 0) {
                compound.setBoolean("acceptTextures", this.acceptTextures == 1);
            }
            return compound;
        }

        public static Server loadFromNBT(NBTTagCompound nbt) {
            Server server = new Server();
            server.setName(nbt.getString("name"));
            server.setAddress(nbt.getString("ip"));
            server.hideAddress = nbt.getBoolean("hideAddress");
            if (nbt.hasKey("acceptTextures")) {
                server.acceptTextures = nbt.getBoolean("acceptTextures") ? 1 : -1;
            }
            return server;
        }

        public static Server parseFromString(String s) throws ParseException {
            if (s == null) {
                throw new NullPointerException();
            }
            try {
                return Server.parseJsonString(s);
            }
            catch (RuntimeException rE) {
                return Server.parsePlainString(s);
            }
        }

        private static Server parsePlainString(String s) throws ParseException {
            String[] array = StringUtils.split(s, ';');
            if (array.length != 4) {
                throw new ParseException("split incorrectly");
            }
            String ip = ServerList.validateNotBlank(array[0], "ip");
            String port = ServerList.validateNotBlank(array[1], "port");
            String version = ServerList.validateNotBlank(array[2], "version");
            String name = ServerList.validateNotBlank(array[3], "name");
            Server server = new Server();
            server.setIp(ip);
            server.setPort(port);
            server.addVersion(version);
            server.setName(name);
            return server;
        }

        private static Server parseJsonString(String s) throws ParseException {
            if (gson == null) {
                gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Server.class), new ServerDeserializer()).create();
            }
            try {
                return gson.fromJson(s, Server.class);
            }
            catch (RuntimeException rE) {
                throw new ParseException("could not parse json server string", rE);
            }
        }
    }

    private static class ServerDeserializer
    implements JsonDeserializer<Server> {
        private ServerDeserializer() {
        }

        @Override
        public Server deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            String name = root.getAsJsonPrimitive("name").getAsString();
            String address = root.getAsJsonPrimitive("address").getAsString();
            List versions = (List)context.deserialize(root.getAsJsonArray("versions"), new TypeToken<List<String>>(){}.getType());
            Server server = new Server();
            server.setName(name);
            server.setAddress(address);
            server.versions.addAll(versions);
            return server;
        }
    }
}

