/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.UUID;
import net.minecraft.launcher.Http;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.Agent;
import ru.turikhay.tlauncher.minecraft.auth.Authenticator;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorException;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorService;
import ru.turikhay.tlauncher.minecraft.auth.GameProfile;
import ru.turikhay.tlauncher.minecraft.auth.InvalidCredentialsException;
import ru.turikhay.tlauncher.minecraft.auth.UUIDTypeAdapter;
import ru.turikhay.tlauncher.minecraft.auth.User;
import ru.turikhay.tlauncher.minecraft.auth.UserMigratedException;

public class StandardAuthenticator
extends Authenticator {
    protected final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).create();
    protected final URL AUTHENTICATE_URL;
    protected final URL REFRESH_URL;

    protected StandardAuthenticator(Account account, String authUrl, String refreshUrl) {
        super(account);
        this.AUTHENTICATE_URL = Http.constantURL(authUrl);
        this.REFRESH_URL = Http.constantURL(refreshUrl);
    }

    @Override
    protected void pass() throws AuthenticatorException {
        if (this.account.isFree()) {
            throw new IllegalArgumentException("invalid account type");
        }
        if (this.account.getPassword() == null && this.account.getAccessToken() == null) {
            throw new AuthenticatorException(new NullPointerException("password/accessToken"));
        }
        this.log("Staring to authenticate:", this.account);
        this.log("hasUsername:", this.account.getUsername());
        this.log("hasPassword:", this.account.getPassword() != null);
        this.log("hasAccessToken:", this.account.getAccessToken() != null);
        if (this.account.getPassword() == null) {
            this.tokenLogin();
        } else {
            this.passwordLogin();
        }
        this.log("Log in successful!");
        this.log("hasUUID:", this.account.getUUID() != null);
        this.log("hasAccessToken:", this.account.getAccessToken() != null);
        this.log("hasProfiles:", this.account.getProfiles() != null);
        this.log("hasProfile:", this.account.getProfiles() != null);
        this.log("hasProperties:", this.account.getProperties() != null);
    }

    protected void passwordLogin() throws AuthenticatorException {
        this.log("Loggining in with password");
        AuthenticationRequest request = new AuthenticationRequest(this);
        AuthenticationResponse response = this.makeRequest(this.AUTHENTICATE_URL, request, AuthenticationResponse.class);
        this.account.setUserID(response.getUserID() != null ? response.getUserID() : this.account.getUsername());
        this.account.setAccessToken(response.getAccessToken());
        this.account.setProfiles(response.getAvailableProfiles());
        this.account.setProfile(response.getSelectedProfile());
        this.account.setUser(response.getUser());
        StandardAuthenticator.setClientToken(response.getClientToken());
        if (response.getSelectedProfile() != null) {
            this.account.setUUID(response.getSelectedProfile().getId());
            this.account.setDisplayName(response.getSelectedProfile().getName());
        }
    }

    protected void tokenLogin() throws AuthenticatorException {
        this.log("Loggining in with token");
        RefreshRequest request = new RefreshRequest(this);
        RefreshResponse response = this.makeRequest(this.REFRESH_URL, request, RefreshResponse.class);
        StandardAuthenticator.setClientToken(response.getClientToken());
        this.account.setAccessToken(response.getAccessToken());
        this.account.setProfile(response.getSelectedProfile());
        this.account.setUser(response.getUser());
    }

    protected <T extends Response> T makeRequest(URL url, Request input, Class<T> classOfT) throws AuthenticatorException {
        Response result;
        String jsonResult;
        if (url == null) {
            throw new NullPointerException("url");
        }
        try {
            jsonResult = input == null ? AuthenticatorService.performGetRequest(url) : AuthenticatorService.performPostRequest(url, this.gson.toJson(input), "application/json");
        }
        catch (IOException e) {
            throw new AuthenticatorException("Error making request, uncaught IOException", "unreachable", e);
        }
        try {
            result = (Response)this.gson.fromJson(jsonResult, classOfT);
        }
        catch (RuntimeException rE) {
            throw new AuthenticatorException("Error parsing response: \"" + jsonResult + "\"", "unparseable", rE);
        }
        if (result == null) {
            return null;
        }
        if (StringUtils.isBlank(result.getError())) {
            return (T)result;
        }
        throw this.getException(result);
    }

    protected AuthenticatorException getException(Response result) {
        if ("UserMigratedException".equals(result.getCause())) {
            return new UserMigratedException();
        }
        if ("ForbiddenOperationException".equals(result.getError())) {
            return new InvalidCredentialsException();
        }
        return new AuthenticatorException(result, "internal");
    }

    protected static class AuthenticationRequest
    extends Request {
        private Agent agent = Agent.MINECRAFT;
        private String username;
        private String password;
        private String clientToken;

        protected AuthenticationRequest(String username, String password, String clientToken) {
            this.username = username;
            this.password = password;
            this.clientToken = clientToken;
        }

        protected AuthenticationRequest(Authenticator auth) {
            this(auth.account.getUsername(), auth.account.getPassword(), Authenticator.getClientToken().toString());
        }

        public Agent getAgent() {
            return this.agent;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public boolean isRequestingUser() {
            return true;
        }
    }

    protected static class AuthenticationResponse
    extends Response {
        private String accessToken;
        private String clientToken;
        private GameProfile selectedProfile;
        private GameProfile[] availableProfiles;
        private User user;

        protected AuthenticationResponse() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public GameProfile[] getAvailableProfiles() {
            return this.availableProfiles;
        }

        public GameProfile getSelectedProfile() {
            return this.selectedProfile;
        }

        public User getUser() {
            return this.user;
        }

        public String getUserID() {
            return this.user != null ? this.user.getID() : null;
        }
    }

    protected static class RefreshRequest
    extends Request {
        private String clientToken;
        private String accessToken;
        private GameProfile selectedProfile;
        private boolean requestUser = true;

        private RefreshRequest(String clientToken, String accessToken, GameProfile profile) {
            this.clientToken = clientToken;
            this.accessToken = accessToken;
            this.selectedProfile = profile;
        }

        RefreshRequest(String clientToken, String accessToken) {
            this(clientToken, accessToken, null);
        }

        private RefreshRequest(Authenticator auth, GameProfile profile) {
            this(Authenticator.getClientToken().toString(), auth.account.getAccessToken(), profile);
        }

        RefreshRequest(Authenticator auth) {
            this(auth, null);
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public GameProfile getProfile() {
            return this.selectedProfile;
        }
    }

    protected static class RefreshResponse
    extends Response {
        private String accessToken;
        private String clientToken;
        private GameProfile selectedProfile;
        private User user;

        protected RefreshResponse() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public GameProfile getSelectedProfile() {
            return this.selectedProfile;
        }

        public User getUser() {
            return this.user;
        }
    }

    protected static class Request {
        protected Request() {
        }
    }

    protected static class Response {
        private String error;
        private String errorMessage;
        private String cause;

        protected Response() {
        }

        public String getError() {
            return this.error;
        }

        public String getCause() {
            return this.cause;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

