/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.UUID;

public class UUIDTypeAdapter
extends TypeAdapter<UUID> {
    @Override
    public void write(JsonWriter out, UUID value) throws IOException {
        out.value(UUIDTypeAdapter.fromUUID(value));
    }

    @Override
    public UUID read(JsonReader in) throws IOException {
        return UUIDTypeAdapter.fromString(in.nextString());
    }

    public static String toUUID(String value) {
        if (value == null) {
            return null;
        }
        return value.replace("-", "");
    }

    public static String fromUUID(UUID value) {
        return UUIDTypeAdapter.toUUID(value.toString());
    }

    public static UUID fromString(String input) {
        return UUID.fromString(input.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }
}

