/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.launcher;

import com.google.gson.Gson;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessListener;
import net.minecraft.launcher.updater.AssetIndex;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ExtractRules;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.downloader.DownloadableContainerHandler;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.managers.AssetsManager;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.managers.ServerListManager;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionSyncInfoContainer;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashDescriptor;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftExtendedListener;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncherAssistant;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.console.Console;
import ru.turikhay.tlauncher.updater.Stats;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.U;
import ru.turikhay.util.stream.LinkedStringStream;
import ru.turikhay.util.stream.PrintLogger;

public class MinecraftLauncher
implements JavaProcessListener {
    private static final int OFFICIAL_VERSION = 16;
    private static final int ALTERNATIVE_VERSION = 8;
    private static final boolean[] ASSETS_PROBLEM = new boolean[2];
    private boolean working;
    private boolean killed;
    private final Thread parentThread;
    private final Gson gson;
    private final DateTypeAdapter dateAdapter;
    private final Downloader downloader;
    private final Configuration settings;
    private final boolean forceUpdate;
    private final boolean assistLaunch;
    private final VersionManager vm;
    private final AssetsManager am;
    private final ProfileManager pm;
    private final ServerListManager sl;
    private final StringBuffer output;
    private final PrintLogger logger;
    private Console console;
    private final ConsoleVisibility consoleVis;
    private CrashDescriptor descriptor;
    private final List<MinecraftListener> listeners;
    private final List<MinecraftExtendedListener> extListeners;
    private final List<MinecraftLauncherAssistant> assistants;
    private MinecraftLauncherStep step;
    private String versionName;
    private VersionSyncInfo versionSync;
    private CompleteVersion version;
    private CompleteVersion deJureVersion;
    private String accountName;
    private Account account;
    private File javaDir;
    private File gameDir;
    private File localAssetsDir;
    private File nativeDir;
    private File globalAssetsDir;
    private File assetsIndexesDir;
    private File assetsObjectsDir;
    private int[] windowSize;
    private boolean fullScreen;
    private boolean fullCommand;
    private int ramSize;
    private JavaProcessLauncher launcher;
    private String javaArgs;
    private String programArgs;
    private boolean minecraftWorking;
    private long startupTime;
    private int exitCode;
    private ServerList.Server server;
    private JavaProcess process;
    private boolean firstLine = true;

    public Downloader getDownloader() {
        return this.downloader;
    }

    public Configuration getConfiguration() {
        return this.settings;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public boolean isLaunchAssist() {
        return this.assistLaunch;
    }

    public String getOutput() {
        return this.console == null ? this.output.toString() : this.console.getOutput();
    }

    public ConsoleVisibility getConsoleVisibility() {
        return this.consoleVis;
    }

    public Console getConsole() {
        return this.console;
    }

    public CrashDescriptor getCrashDescriptor() {
        return this.descriptor;
    }

    public MinecraftLauncherStep getStep() {
        return this.step;
    }

    public boolean isWorking() {
        return this.working;
    }

    private MinecraftLauncher(ComponentManager manager, Downloader downloader, Configuration configuration, boolean forceUpdate, ConsoleVisibility visibility, boolean exit) {
        if (manager == null) {
            throw new NullPointerException("Ti sovsem s duba ruhnul?");
        }
        if (downloader == null) {
            throw new NullPointerException("Downloader is NULL!");
        }
        if (configuration == null) {
            throw new NullPointerException("Configuration is NULL!");
        }
        if (visibility == null) {
            throw new NullPointerException("ConsoleVisibility is NULL!");
        }
        this.parentThread = Thread.currentThread();
        this.gson = new Gson();
        this.dateAdapter = new DateTypeAdapter();
        this.downloader = downloader;
        this.settings = configuration;
        this.assistants = manager.getComponentsOf(MinecraftLauncherAssistant.class);
        this.vm = manager.getComponent(VersionManager.class);
        this.am = manager.getComponent(AssetsManager.class);
        this.pm = manager.getComponent(ProfileManager.class);
        this.sl = manager.getComponent(ServerListManager.class);
        this.forceUpdate = forceUpdate;
        this.assistLaunch = !exit;
        this.consoleVis = visibility;
        PrintLogger printLogger = this.logger = this.consoleVis.equals((Object)ConsoleVisibility.NONE) ? null : new PrintLogger(new LinkedStringStream());
        this.console = this.logger == null ? null : new Console(this.settings, this.logger, "Minecraft", this.consoleVis.equals((Object)ConsoleVisibility.ALWAYS) && this.assistLaunch);
        StringBuffer stringBuffer = this.output = this.console == null ? new StringBuffer() : null;
        if (this.console != null) {
            this.console.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Console con = MinecraftLauncher.this.console;
                    MinecraftLauncher.this.console = null;
                    con.kill();
                }
            });
        }
        this.descriptor = new CrashDescriptor(this);
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.extListeners = Collections.synchronizedList(new ArrayList());
        this.step = MinecraftLauncherStep.NONE;
        this.log("Minecraft Launcher [16;8] has initialized");
        this.log("Running under TLauncher " + TLauncher.getVersion() + " " + TLauncher.getBrand());
        this.log("Current machine:", OS.getSummary());
    }

    public MinecraftLauncher(TLauncher t, boolean forceUpdate) {
        this(t.getManager(), t.getDownloader(), t.getSettings(), forceUpdate, t.getSettings().getConsoleType().getVisibility(), t.getSettings().getActionOnLaunch() == Configuration.ActionOnLaunch.EXIT);
    }

    public void addListener(MinecraftListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (listener instanceof MinecraftExtendedListener) {
            this.extListeners.add((MinecraftExtendedListener)listener);
        }
        this.listeners.add(listener);
    }

    /*
     * Unable to fully structure code
     */
    public void start() {
        block7: {
            block8: {
                this.checkWorking();
                this.working = true;
                try {
                    this.collectInfo();
                    break block7;
                }
                catch (Throwable e) {
                    this.log(new Object[]{"Error occurred:", e});
                    if (!(e instanceof MinecraftException)) break block8;
                    me = (MinecraftException)e;
                    ** for (listener : this.listeners)
                }
lbl-1000:
                // 1 sources

                {
                    listener.onMinecraftKnownError(me);
                    continue;
lbl13:
                    // 1 sources

                    break block7;
                }
            }
            if (e instanceof MinecraftLauncherAborted) {
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftAbort();
                }
            } else {
                for (MinecraftListener listener : this.listeners) {
                    listener.onMinecraftError(e);
                }
            }
        }
        this.working = false;
        this.step = MinecraftLauncherStep.NONE;
        this.log(new Object[]{"Launcher exited."});
    }

    public void stop() {
        if (this.step == MinecraftLauncherStep.NONE) {
            throw new IllegalStateException();
        }
        if (this.step == MinecraftLauncherStep.DOWNLOADING) {
            this.downloader.stopDownload();
        }
        this.working = false;
    }

    public String getVersion() {
        return this.versionName;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public ServerList.Server getServer() {
        return this.server;
    }

    public void setServer(ServerList.Server server) {
        this.checkWorking();
        this.server = server;
    }

    private void collectInfo() throws MinecraftException {
        String javaDirPath;
        this.checkStep(MinecraftLauncherStep.NONE, MinecraftLauncherStep.COLLECTING);
        this.log("Collecting info...");
        for (MinecraftListener minecraftListener : this.listeners) {
            minecraftListener.onMinecraftPrepare();
        }
        for (MinecraftExtendedListener minecraftExtendedListener : this.extListeners) {
            minecraftExtendedListener.onMinecraftCollecting();
        }
        this.log("Force update:", this.forceUpdate);
        this.versionName = this.settings.get("login.version");
        if (this.versionName == null || this.versionName.isEmpty()) {
            throw new IllegalArgumentException("Version name is NULL or empty!");
        }
        this.log("Selected version:", this.versionName);
        this.accountName = this.settings.get("login.account");
        if (this.accountName == null || this.accountName.isEmpty()) {
            throw new IllegalArgumentException("Account is NULL or empty!");
        }
        Account.AccountType accountType = Reflect.parseEnum(Account.AccountType.class, this.settings.get("login.account.type"));
        this.account = this.pm.getAuthDatabase().getByUsername(this.accountName, accountType);
        if (this.account == null) {
            this.account = new Account(this.accountName);
        }
        this.log("Selected account:", this.account.toDebugString());
        this.versionSync = this.vm.getVersionSyncInfo(this.versionName);
        if (this.versionSync == null) {
            throw new IllegalArgumentException("Cannot find version " + this.version);
        }
        this.log("Version sync info:", this.versionSync);
        try {
            this.deJureVersion = this.versionSync.resolveCompleteVersion(this.vm, this.forceUpdate);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot get complete version!");
        }
        if (this.deJureVersion == null) {
            throw new NullPointerException("Complete version is NULL");
        }
        this.version = this.account.getType() == Account.AccountType.ELY ? TLauncher.getInstance().getElyManager().elyficate(this.deJureVersion) : this.deJureVersion;
        if (this.console != null) {
            this.console.setName(this.version.getID());
        }
        this.javaDir = new File((javaDirPath = this.settings.get("minecraft.javadir")) == null ? OS.getJavaPath() : javaDirPath);
        this.log("Java path:", this.javaDir);
        this.gameDir = new File(this.settings.get("minecraft.gamedir"));
        try {
            FileUtil.createFolder(this.gameDir);
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot create working directory!", "folder-not-found", e);
        }
        this.globalAssetsDir = new File(this.gameDir, "assets");
        try {
            FileUtil.createFolder(this.globalAssetsDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create assets directory!", e);
        }
        this.assetsIndexesDir = new File(this.globalAssetsDir, "indexes");
        try {
            FileUtil.createFolder(this.assetsIndexesDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create assets indexes directory!", e);
        }
        this.assetsObjectsDir = new File(this.globalAssetsDir, "objects");
        try {
            FileUtil.createFolder(this.assetsObjectsDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create assets objects directory!", e);
        }
        this.nativeDir = new File(this.gameDir, "versions/" + this.version.getID() + "/" + "natives");
        try {
            FileUtil.createFolder(this.nativeDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create native files directory!", e);
        }
        this.javaArgs = this.settings.get("minecraft.javaargs");
        if (this.javaArgs != null && this.javaArgs.isEmpty()) {
            this.javaArgs = null;
        }
        this.programArgs = this.settings.get("minecraft.args");
        if (this.programArgs != null && this.programArgs.isEmpty()) {
            this.programArgs = null;
        }
        this.windowSize = this.settings.getClientWindowSize();
        if (this.windowSize[0] < 1) {
            throw new IllegalArgumentException("Invalid window width!");
        }
        if (this.windowSize[1] < 1) {
            throw new IllegalArgumentException("Invalid window height!");
        }
        this.fullScreen = this.settings.getBoolean("minecraft.fullscreen");
        this.ramSize = this.settings.getInteger("minecraft.memory");
        if (this.ramSize < 512) {
            throw new IllegalArgumentException("Invalid RAM size!");
        }
        this.fullCommand = this.settings.getBoolean("gui.console.fullcommand");
        for (MinecraftLauncherAssistant assistant : this.assistants) {
            assistant.collectInfo();
        }
        this.log("Checking conditions...");
        if (this.version.getMinimumCustomLauncherVersion() > 8) {
            throw new MinecraftException("Alternative launcher is incompatible with launching version!", "incompatible", new Object[0]);
        }
        if (this.version.getMinimumCustomLauncherVersion() == 0 && this.version.getMinimumLauncherVersion() > 16) {
            Alert.showLocWarning("launcher.warning.title", (Object)"launcher.warning.incompatible.launcher");
        }
        if (!this.version.appliesToCurrentEnvironment()) {
            Alert.showLocWarning("launcher.warning.title", (Object)"launcher.warning.incompatible.environment");
        }
        this.downloadResources();
    }

    private void downloadResources() throws MinecraftException {
        VersionSyncInfoContainer execContainer;
        this.checkStep(MinecraftLauncherStep.COLLECTING, MinecraftLauncherStep.DOWNLOADING);
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftComparingAssets();
        }
        final List<AssetIndex.AssetObject> assets = this.compareAssets();
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftDownloading();
        }
        try {
            execContainer = this.vm.downloadVersion(this.versionSync, this.account.getType() == Account.AccountType.ELY, this.forceUpdate);
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot download version!", "download-jar", e);
        }
        execContainer.setConsole(this.console);
        execContainer.addHandler(new DownloadableContainerHandler(){

            @Override
            public void onStart(DownloadableContainer c) {
            }

            @Override
            public void onAbort(DownloadableContainer c) {
            }

            @Override
            public void onError(DownloadableContainer c, Downloadable d, Throwable e) {
            }

            @Override
            public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
                if (d instanceof Library.LibraryDownloadable) {
                    Library lib = ((Library.LibraryDownloadable)d).getDownloadableLibrary();
                    if (lib.getChecksum() == null) {
                        return;
                    }
                    String fileHash = FileUtil.getChecksum(d.getDestination(), "sha1");
                    if (fileHash == null || fileHash.equals(lib.getChecksum())) {
                        return;
                    }
                    throw new RetryDownloadException("illegal library hash. got: " + fileHash + "; expected: " + lib.getChecksum());
                }
            }

            @Override
            public void onFullComplete(DownloadableContainer c) {
            }
        });
        DownloadableContainer assetsContainer = null;
        assetsContainer = this.am.downloadResources(this.version, assets, this.forceUpdate);
        final boolean[] kasperkyBlocking = new boolean[1];
        if (assetsContainer != null) {
            assetsContainer.addHandler(new DownloadableContainerHandler(){

                @Override
                public void onStart(DownloadableContainer c) {
                }

                @Override
                public void onAbort(DownloadableContainer c) {
                }

                @Override
                public void onError(DownloadableContainer c, Downloadable d, Throwable e) {
                }

                @Override
                public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
                    String filename = d.getFilename();
                    AssetIndex.AssetObject object = null;
                    for (AssetIndex.AssetObject asset : assets) {
                        if (!filename.equals(asset.getHash())) continue;
                        object = asset;
                    }
                    if (object == null) {
                        MinecraftLauncher.this.log("Couldn't find object:", filename);
                        return;
                    }
                    File destination = d.getDestination();
                    String hash = FileUtil.getDigest(destination, "SHA-1", 40);
                    if (hash == null) {
                        throw new RetryDownloadException("File hash is NULL!");
                    }
                    String assetHash = object.getHash();
                    if (assetHash == null) {
                        MinecraftLauncher.this.log("Hash of", object.getHash(), "is NULL");
                        return;
                    }
                    if (!hash.equals(assetHash)) {
                        if (hash.equals("2daeaa8b5f19f0bc209d976c02bd6acb51b00b0a")) {
                            kasperkyBlocking[0] = true;
                        }
                        throw new RetryDownloadException("illegal hash. got: " + hash + "; expected: " + assetHash);
                    }
                }

                @Override
                public void onFullComplete(DownloadableContainer c) {
                    MinecraftLauncher.this.log("Assets have been downloaded");
                }
            });
            assetsContainer.setConsole(this.console);
        }
        if (assetsContainer != null) {
            this.downloader.add(assetsContainer);
        }
        this.downloader.add(execContainer);
        for (MinecraftLauncherAssistant assistant : this.assistants) {
            assistant.collectResources(this.downloader);
        }
        this.downloader.startDownloadAndWait();
        if (execContainer.isAborted()) {
            throw new MinecraftLauncherAborted((Throwable)new AbortedDownloadException());
        }
        if (!execContainer.getErrors().isEmpty()) {
            boolean onlyOne = execContainer.getErrors().size() == 1;
            StringBuilder message = new StringBuilder();
            message.append(execContainer.getErrors().size()).append(" error").append(onlyOne ? "" : "s").append(" occurred while trying to download binaries.");
            if (!onlyOne) {
                message.append(" Cause is the first of them.");
            }
            throw new MinecraftException(message.toString(), "download", execContainer.getErrors().get(0));
        }
        if (assetsContainer != null && !assetsContainer.getErrors().isEmpty() && !(assetsContainer.getErrors().get(0) instanceof AbortedDownloadException)) {
            if (kasperkyBlocking[0] && !ASSETS_PROBLEM[1]) {
                Alert.showLocWarning("launcher.warning.title", "launcher.warning.assets.kaspersky", "http://resources.download.minecraft.net/ad/ad*");
                MinecraftLauncher.ASSETS_PROBLEM[1] = true;
            } else if (!ASSETS_PROBLEM[0]) {
                Alert.showLocWarning("launcher.warning.title", (Object)"launcher.warning.assets");
                MinecraftLauncher.ASSETS_PROBLEM[0] = true;
            }
        } else {
            Arrays.fill(ASSETS_PROBLEM, false);
        }
        try {
            this.vm.getLocalList().saveVersion(this.deJureVersion);
        }
        catch (IOException e) {
            this.log("Cannot save version!", e);
        }
        this.constructProcess();
    }

    private void constructProcess() throws MinecraftException {
        ServerList serverList;
        this.checkStep(MinecraftLauncherStep.DOWNLOADING, MinecraftLauncherStep.CONSTRUCTING);
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftReconstructingAssets();
        }
        try {
            this.localAssetsDir = this.reconstructAssets();
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot recounstruct assets!", "reconstruct-assets", e);
        }
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftUnpackingNatives();
        }
        try {
            this.unpackNatives(this.forceUpdate);
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot unpack natives!", "unpack-natives", e);
        }
        this.checkAborted();
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftDeletingEntries();
        }
        try {
            this.deleteEntries();
        }
        catch (IOException e) {
            throw new MinecraftException("Cannot delete entries!", "delete-entries", e);
        }
        try {
            this.deleteLibraryEntries();
        }
        catch (Exception e) {
            throw new MinecraftException("Cannot delete library entries!", "delete-entries", e);
        }
        this.checkAborted();
        this.log("Constructing process...");
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftConstructing();
        }
        this.launcher = new JavaProcessLauncher(this.javaDir.getAbsolutePath(), new String[0]);
        this.launcher.directory(this.gameDir);
        if (OS.OSX.isCurrent()) {
            File icon = null;
            try {
                icon = this.getAssetObject("icons/minecraft.icns");
            }
            catch (IOException e) {
                this.log("Cannot get icon file from assets.", e);
            }
            if (icon != null) {
                this.launcher.addCommand("-Xdock:icon=\"" + icon.getAbsolutePath() + "\"", "-Xdock:name=Minecraft");
            }
        }
        this.launcher.addCommand("-Xmx" + this.ramSize + "M");
        this.launcher.addCommand("-Djava.library.path=" + this.nativeDir.getAbsolutePath());
        this.launcher.addCommand("-cp", this.constructClassPath(this.version));
        this.launcher.addCommand("-Dfml.ignoreInvalidMinecraftCertificates=true");
        this.launcher.addCommand("-Dfml.ignorePatchDiscrepancies=true");
        this.launcher.addCommands(this.getJVMArguments());
        if (this.javaArgs != null) {
            this.launcher.addSplitCommands(this.javaArgs);
        }
        for (MinecraftLauncherAssistant assistant : this.assistants) {
            assistant.constructJavaArguments();
        }
        this.launcher.addCommand(this.version.getMainClass());
        if (!this.fullCommand) {
            this.log("Half command (characters are not escaped):\n" + this.launcher.getCommandsAsString());
        }
        this.launcher.addCommands(this.getMinecraftArguments());
        this.launcher.addCommand("--width", this.windowSize[0]);
        this.launcher.addCommand("--height", this.windowSize[1]);
        if (this.fullScreen) {
            this.launcher.addCommand("--fullscreen");
        }
        if (this.server != null) {
            serverList = new ServerList();
            serverList.add(this.server);
            try {
                ServerListManager.reconstructList(serverList, new File(this.gameDir, "servers.dat"));
            }
            catch (Exception e) {
                this.log("Couldn't reconstruct server list.", e);
            }
            String[] address = StringUtils.split(this.server.getAddress(), ':');
            switch (address.length) {
                case 2: {
                    this.launcher.addCommand("--port", address[1]);
                }
                case 1: {
                    this.launcher.addCommand("--server", address[0]);
                    break;
                }
                default: {
                    this.log("Cannot recognize server:", this.server);
                }
            }
        }
        if ((serverList = this.sl.getList()) != null) {
            try {
                ServerListManager.reconstructList(serverList, new File(this.gameDir, "servers.dat"));
            }
            catch (Exception e) {
                this.log("Couldn't reconstruct remote server list.", e);
            }
        }
        if (this.programArgs != null) {
            this.launcher.addSplitCommands(this.programArgs);
        }
        for (MinecraftLauncherAssistant assistant : this.assistants) {
            assistant.constructProgramArguments();
        }
        if (this.fullCommand) {
            this.log("Full command (characters are not escaped):\n" + this.launcher.getCommandsAsString());
        }
        this.launchMinecraft();
    }

    private File reconstructAssets() throws IOException {
        String assetVersion = this.version.getAssets() == null ? "legacy" : this.version.getAssets();
        File indexFile = new File(this.assetsIndexesDir, String.valueOf(assetVersion) + ".json");
        File virtualRoot = new File(new File(this.globalAssetsDir, "virtual"), assetVersion);
        if (!indexFile.isFile()) {
            this.log("No assets index file " + virtualRoot + "; can't reconstruct assets");
            return virtualRoot;
        }
        AssetIndex index = this.gson.fromJson(FileUtil.readFile(indexFile), AssetIndex.class);
        if (index.isVirtual()) {
            this.log("Reconstructing virtual assets folder at " + virtualRoot);
            for (Map.Entry<String, AssetIndex.AssetObject> entry : index.getFileMap().entrySet()) {
                this.checkAborted();
                File target = new File(virtualRoot, entry.getKey());
                File original = new File(new File(this.assetsObjectsDir, entry.getValue().getHash().substring(0, 2)), entry.getValue().getHash());
                if (!original.isFile()) {
                    this.log("Skipped reconstructing:", original);
                    continue;
                }
                if (!this.forceUpdate && target.isFile()) continue;
                FileUtils.copyFile(original, target, false);
                this.log(original, "->", target);
            }
            FileUtil.writeFile(new File(virtualRoot, ".lastused"), this.dateAdapter.toString(new Date()));
        }
        return virtualRoot;
    }

    private File getAssetObject(String name) throws IOException {
        String assetVersion = this.version.getAssets();
        File indexFile = new File(this.assetsIndexesDir, String.valueOf(assetVersion) + ".json");
        AssetIndex index = this.gson.fromJson(FileUtil.readFile(indexFile), AssetIndex.class);
        if (index.getFileMap() == null) {
            throw new IOException("Cannot get filemap!");
        }
        String hash = index.getFileMap().get(name).getHash();
        return new File(this.assetsObjectsDir, String.valueOf(hash.substring(0, 2)) + "/" + hash);
    }

    private void unpackNatives(boolean force) throws IOException {
        this.log("Unpacking natives...");
        Collection<Library> libraries = this.version.getRelevantLibraries();
        OS os = OS.CURRENT;
        ZipFile zip = null;
        if (force) {
            this.nativeDir.delete();
        }
        for (Library library : libraries) {
            Map<OS, String> nativesPerOs = library.getNatives();
            if (nativesPerOs == null || nativesPerOs.get((Object)os) == null) continue;
            File file = new File(MinecraftUtil.getWorkingDirectory(), "libraries/" + library.getArtifactPath(nativesPerOs.get((Object)os)));
            if (!file.isFile()) {
                throw new IOException("Required archive doesn't exist: " + file.getAbsolutePath());
            }
            try {
                zip = new ZipFile(file);
            }
            catch (IOException e) {
                throw new IOException("Error opening ZIP archive: " + file.getAbsolutePath(), e);
            }
            ExtractRules extractRules = library.getExtractRules();
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int length;
                ZipEntry entry = entries.nextElement();
                if (extractRules != null && !extractRules.shouldExtract(entry.getName())) continue;
                File targetFile = new File(this.nativeDir, entry.getName());
                if (!force && targetFile.isFile()) continue;
                if (targetFile.getParentFile() != null) {
                    targetFile.getParentFile().mkdirs();
                }
                if (entry.isDirectory()) continue;
                BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(entry));
                byte[] buffer = new byte[2048];
                FileOutputStream outputStream = new FileOutputStream(targetFile);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                    bufferedOutputStream.write(buffer, 0, length);
                }
                inputStream.close();
                bufferedOutputStream.close();
            }
            zip.close();
        }
    }

    private void deleteEntries() throws IOException {
        List<String> entries = this.version.getDeleteEntries();
        if (entries == null || entries.size() == 0) {
            return;
        }
        this.log("Removing entries...");
        File file = this.version.getFile(this.gameDir);
        this.removeFrom(file, entries);
    }

    private void deleteLibraryEntries() throws IOException {
        for (Library lib : this.version.getLibraries()) {
            List<String> entries = lib.getDeleteEntriesList();
            if (entries == null || entries.isEmpty()) continue;
            this.log("Processing entries of", lib.getName());
            this.removeFrom(new File(this.gameDir, "libraries/" + lib.getArtifactPath()), entries);
        }
    }

    private String constructClassPath(CompleteVersion version) throws MinecraftException {
        this.log("Constructing classpath...");
        StringBuilder result = new StringBuilder();
        Collection<File> classPath = version.getClassPath(OS.CURRENT, this.gameDir);
        String separator = System.getProperty("path.separator");
        for (File file : classPath) {
            if (!file.isFile()) {
                throw new MinecraftException("Classpath is not found: " + file, "classpath", file);
            }
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(file.getAbsolutePath());
        }
        return result.toString();
    }

    private String[] getMinecraftArguments() throws MinecraftException {
        this.log("Getting Minecraft arguments...");
        if (this.version.getMinecraftArguments() == null) {
            throw new MinecraftException("Can't run version, missing minecraftArguments", "noArgs", new Object[0]);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StrSubstitutor substitutor = new StrSubstitutor(map);
        String assets = this.version.getAssets();
        String[] split = this.version.getMinecraftArguments().split(" ");
        map.put("auth_username", this.accountName);
        if (!this.account.isFree()) {
            map.put("auth_session", String.format("token:%s:%s", this.account.getAccessToken(), this.account.getProfile().getId()));
            map.put("auth_access_token", this.account.getAccessToken());
            map.put("user_properties", this.gson.toJson(this.account.getProperties()));
            map.put("auth_player_name", this.account.getDisplayName());
            map.put("auth_uuid", this.account.getUUID());
            map.put("user_type", "mojang");
            map.put("profile_name", this.account.getProfile().getName());
        } else {
            map.put("auth_session", "null");
            map.put("auth_access_token", "null");
            map.put("user_properties", "[]");
            map.put("auth_player_name", this.accountName);
            map.put("auth_uuid", new UUID(0L, 0L).toString());
            map.put("user_type", "legacy");
            map.put("profile_name", "(Default)");
        }
        map.put("version_name", this.version.getID());
        map.put("game_directory", this.gameDir.getAbsolutePath());
        map.put("game_assets", this.localAssetsDir.getAbsolutePath());
        map.put("assets_root", this.globalAssetsDir.getAbsolutePath());
        map.put("assets_index_name", assets == null ? "legacy" : assets);
        int i = 0;
        while (i < split.length) {
            split[i] = substitutor.replace(split[i]);
            ++i;
        }
        return split;
    }

    private String[] getJVMArguments() {
        String jvmargs = this.version.getJVMArguments();
        if (StringUtils.isNotEmpty(jvmargs)) {
            return StringUtils.split(jvmargs, ' ');
        }
        return StringUtils.split("-XX:+UseConcMarkSweepGC -XX:+CMSIncrementalMode -XX:-UseAdaptiveSizePolicy -Xmn128M", ' ');
    }

    private List<AssetIndex.AssetObject> compareAssets() {
        this.migrateOldAssets();
        this.log("Comparing assets...");
        long start = System.nanoTime();
        List<AssetIndex.AssetObject> result = this.am.checkResources(this.version, !this.forceUpdate);
        long end = System.nanoTime();
        long delta = end - start;
        this.log("Delta time to compare assets: " + delta / 1000000L + " ms.");
        return result;
    }

    private void migrateOldAssets() {
        if (!this.globalAssetsDir.isDirectory()) {
            return;
        }
        File skinsDir = new File(this.globalAssetsDir, "skins");
        if (skinsDir.isDirectory()) {
            FileUtil.deleteDirectory(skinsDir);
        }
        IOFileFilter migratableFilter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("indexes"), FileFilterUtils.nameFileFilter("objects"), FileFilterUtils.nameFileFilter("virtual")));
        for (File file : new TreeSet<File>(FileUtils.listFiles(this.globalAssetsDir, TrueFileFilter.TRUE, migratableFilter))) {
            String hash = FileUtil.getDigest(file, "SHA-1", 40);
            File destinationFile = new File(this.assetsObjectsDir, String.valueOf(hash.substring(0, 2)) + "/" + hash);
            if (!destinationFile.exists()) {
                this.log("Migrated old asset", file, "into", destinationFile);
                try {
                    FileUtils.copyFile(file, destinationFile);
                }
                catch (IOException e) {
                    this.log("Couldn't migrate old asset", e);
                }
            }
            FileUtils.deleteQuietly(file);
        }
        File[] assets = this.globalAssetsDir.listFiles();
        if (assets != null) {
            File[] fileArray = assets;
            int n = assets.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!(file.getName().equals("indexes") || file.getName().equals("objects") || file.getName().equals("virtual"))) {
                    this.log("Cleaning up old assets directory", file, "after migration");
                    FileUtils.deleteQuietly(file);
                }
                ++n2;
            }
        }
    }

    private void launchMinecraft() throws MinecraftException {
        this.checkStep(MinecraftLauncherStep.CONSTRUCTING, MinecraftLauncherStep.LAUNCHING);
        this.log("Launching Minecraft...");
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftLaunch();
        }
        this.log("Starting Minecraft " + this.versionName + "...");
        this.log("Launching in:", this.gameDir.getAbsolutePath());
        this.startupTime = System.currentTimeMillis();
        TLauncher.getConsole().setLauncher(this);
        if (this.console != null) {
            Calendar startDate = Calendar.getInstance();
            startDate.setTimeInMillis(this.startupTime);
            this.console.setName(String.valueOf(this.version.getID()) + " (" + DateFormat.getDateTimeInstance().format(startDate.getTime()) + ")");
            this.console.setLauncher(this);
        }
        try {
            this.process = this.launcher.start();
            this.process.safeSetExitRunnable(this);
            this.minecraftWorking = true;
        }
        catch (Exception e) {
            this.notifyClose();
            throw new MinecraftException("Cannot start the game!", "start", e);
        }
        this.postLaunch();
    }

    private void postLaunch() {
        this.checkStep(MinecraftLauncherStep.LAUNCHING, MinecraftLauncherStep.POSTLAUNCH);
        this.log("Processing post-launch actions. Assist launch:", this.assistLaunch);
        for (MinecraftExtendedListener listener : this.extListeners) {
            listener.onMinecraftPostLaunch();
        }
        Stats.minecraftLaunched(this.account, this.version, this.server);
        if (this.assistLaunch) {
            this.waitForClose();
        } else {
            U.sleepFor(30000L);
            if (this.minecraftWorking) {
                TLauncher.kill();
            }
        }
    }

    public void killProcess() {
        if (!this.minecraftWorking) {
            throw new IllegalStateException();
        }
        this.log("Killing Minecraft forcefully");
        this.killed = true;
        this.process.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plog(Object ... o) {
        String text = U.toLog(o);
        if (this.console == null) {
            StringBuffer stringBuffer = this.output;
            synchronized (stringBuffer) {
                this.output.append(text).append('\n');
            }
        } else {
            this.console.log(text);
        }
    }

    public void log(Object ... o) {
        U.log("[Launcher]", o);
        this.plog("[L]", o);
    }

    private void checkThread() {
        if (!Thread.currentThread().equals(this.parentThread)) {
            throw new IllegalStateException("Illegal thread!");
        }
    }

    private void checkStep(MinecraftLauncherStep prevStep, MinecraftLauncherStep currentStep) {
        this.checkAborted();
        if (prevStep == null || currentStep == null) {
            throw new NullPointerException("NULL: " + (Object)((Object)prevStep) + " " + (Object)((Object)currentStep));
        }
        if (!this.step.equals((Object)prevStep)) {
            throw new IllegalStateException("Called from illegal step: " + (Object)((Object)this.step));
        }
        this.checkThread();
        this.step = currentStep;
    }

    private void checkAborted() {
        if (!this.working) {
            throw new MinecraftLauncherAborted("Aborted at step: " + (Object)((Object)this.step));
        }
    }

    private void checkWorking() {
        if (this.working) {
            throw new IllegalStateException("Launcher is working!");
        }
    }

    @Override
    public void onJavaProcessLog(JavaProcess jp, String line) {
        if (this.firstLine) {
            this.firstLine = false;
            U.plog("===============================================================================================");
            this.plog("===============================================================================================");
        }
        U.plog(">", line);
        this.plog(line);
    }

    @Override
    public void onJavaProcessEnded(JavaProcess jp) {
        Crash crash;
        this.notifyClose();
        if (TLauncher.getConsole().getLauncher() == this) {
            TLauncher.getConsole().setLauncher(null);
        }
        if (this.console != null) {
            this.console.setLauncher(null);
        }
        int exit = jp.getExitCode();
        this.log("Minecraft closed with exit code: " + exit);
        this.exitCode = exit;
        Crash crash2 = crash = this.killed ? null : this.descriptor.scan();
        if (crash == null) {
            if (!this.assistLaunch) {
                TLauncher.kill();
            }
            if (this.console != null) {
                this.console.killIn(7000L);
            }
        } else {
            if (this.console != null) {
                this.console.show();
            }
            for (MinecraftListener listener : this.listeners) {
                listener.onMinecraftCrash(crash);
            }
        }
    }

    @Override
    public void onJavaProcessError(JavaProcess jp, Throwable e) {
        this.notifyClose();
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftError(e);
        }
    }

    private synchronized void waitForClose() {
        while (this.minecraftWorking) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void notifyClose() {
        this.minecraftWorking = false;
        if (System.currentTimeMillis() - this.startupTime < 5000L) {
            U.sleepFor(1000L);
        }
        this.notifyAll();
        for (MinecraftListener listener : this.listeners) {
            listener.onMinecraftClose();
        }
    }

    private void removeFrom(File zipFile, List<String> entries) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        tempFile.deleteOnExit();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new IOException("Could not rename the file " + zipFile.getAbsolutePath() + " -> " + tempFile.getAbsolutePath());
        }
        this.log("Removing entries from", zipFile);
        byte[] buf = new byte[1024];
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(tempFile)));
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            if (entries.contains(name)) {
                this.log("Removed:", name);
            } else {
                int len;
                zout.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    zout.write(buf, 0, len);
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
        zout.close();
        tempFile.delete();
    }

    public static enum ConsoleVisibility {
        ALWAYS,
        ON_CRASH,
        NONE;

    }

    class MinecraftLauncherAborted
    extends RuntimeException {
        private static final long serialVersionUID = -3001265213093607559L;

        MinecraftLauncherAborted(String message) {
            super(message);
        }

        MinecraftLauncherAborted(Throwable cause) {
            super(cause);
        }
    }

    public static enum MinecraftLauncherStep {
        NONE,
        COLLECTING,
        DOWNLOADING,
        CONSTRUCTING,
        LAUNCHING,
        POSTLAUNCH;

    }
}

