/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.rmo;

import java.io.File;
import java.io.IOException;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessListener;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.U;

public final class Bootstrapper {
    private static final String MAIN_CLASS = "ru.turikhay.tlauncher.rmo.TLauncher";
    private static final int MAX_MEMORY = 128;
    private static final File DIRECTORY = new File(".");
    private final JavaProcessLauncher processLauncher;
    private final BootstrapperListener listener;
    private JavaProcess process;
    private boolean started;

    public static void main(String[] args) {
        try {
            new Bootstrapper(args).start();
        }
        catch (JFXLibraryNotFoundException jfxException) {
            Alert.showError("Cannot find JavaFX library!", "Bootstrapper couldn't find JavaFX library.\nPlease install Java 7 or Java 8 from <a href=\"http://java.com\">Java.com</a>");
        }
        catch (IOException e) {
            e.printStackTrace();
            TLauncher.main(args);
        }
    }

    public static JavaProcessLauncher createLauncher(String[] args, boolean loadAdditionalArgs) {
        Object[] extraArgs;
        File argsFile;
        String classPath;
        JavaProcessLauncher processLauncher = new JavaProcessLauncher(null, new String[0]);
        processLauncher.directory(DIRECTORY);
        processLauncher.addCommand("-Xmx128m");
        if (OS.JAVA_VERSION < 1.8) {
            File fxLib = new File(String.valueOf(OS.getJavaPath(false)) + "lib/jfxrt.jar");
            if (!fxLib.isFile()) {
                throw new JFXLibraryNotFoundException();
            }
            classPath = Bootstrapper.build(fxLib, FileUtil.getRunningJar());
        } else {
            classPath = FileUtil.getRunningJar().getPath();
        }
        processLauncher.addCommand("-cp", classPath);
        processLauncher.addCommand(MAIN_CLASS);
        if (args != null && args.length > 0) {
            processLauncher.addCommands(args);
        }
        if (loadAdditionalArgs && (argsFile = new File(DIRECTORY, "tlauncher.args")).isFile() && (extraArgs = Bootstrapper.loadArgsFromFile(argsFile)) != null) {
            processLauncher.addCommands(extraArgs);
        }
        return processLauncher;
    }

    public static JavaProcessLauncher createLauncher(String[] args) {
        return Bootstrapper.createLauncher(args, true);
    }

    private static String build(File ... files) {
        StringBuilder result = new StringBuilder();
        String separator = System.getProperty("path.separator");
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null) {
                if (result.length() > 0) {
                    result.append(separator);
                }
                result.append(file.getAbsolutePath());
            }
            ++n2;
        }
        return result.toString();
    }

    public Bootstrapper(String[] args) {
        this.processLauncher = Bootstrapper.createLauncher(args);
        this.listener = new BootstrapperListener();
    }

    public void start() throws IOException {
        if (this.process != null) {
            throw new IllegalStateException("Process is already started");
        }
        Bootstrapper.log("Starting launcher...");
        this.process = this.processLauncher.start();
        this.process.safeSetExitRunnable(this.listener);
    }

    private void die(int status) {
        Bootstrapper.log("I can be terminated now.");
        if (!this.started && this.process.isRunning()) {
            Bootstrapper.log("...started instance also will be terminated.");
            Bootstrapper.log("Ni tebe, ni mne, haha!");
            this.process.stop();
        }
        System.exit(status);
    }

    private static String[] loadArgsFromFile(File file) {
        String content;
        Bootstrapper.log("Loading arguments from file:", file);
        try {
            content = FileUtil.readFile(file);
        }
        catch (IOException ioE) {
            Bootstrapper.log("Cannot load arguments from file:", file);
            return null;
        }
        return StringUtils.split(content, ' ');
    }

    private static void log(Object ... s) {
        U.log("[Bootstrapper]", s);
    }

    private class BootstrapperListener
    implements JavaProcessListener {
        private StringBuffer buffer = new StringBuffer();

        private BootstrapperListener() {
        }

        @Override
        public void onJavaProcessLog(JavaProcess jp, String line) {
            U.plog(Character.valueOf('>'), line);
            this.buffer.append(line).append('\n');
            if (line.startsWith("[Loading]")) {
                if (line.length() < "[Loading]".length() + 2) {
                    Bootstrapper.log(new Object[]{"Cannot parse line: content is empty."});
                    return;
                }
                String content = line.substring("[Loading]".length() + 1);
                LoadingStep step = Reflect.parseEnum(LoadingStep.class, content);
                if (step == null) {
                    Bootstrapper.log(new Object[]{"Cannot parse line: cannot parse step"});
                    return;
                }
                if (step.percentage == 100) {
                    Bootstrapper.this.started = true;
                    Bootstrapper.this.die(0);
                }
            }
        }

        @Override
        public void onJavaProcessEnded(JavaProcess jp) {
            int exit = jp.getExitCode();
            if (exit != 0) {
                Alert.showError("Error starting TLauncher", "TLauncher application was closed with illegal exit code (" + exit + "). See console:", this.buffer.toString());
            }
            Bootstrapper.this.die(exit);
        }

        @Override
        public void onJavaProcessError(JavaProcess jp, Throwable e) {
        }
    }

    private static class JFXLibraryNotFoundException
    extends RuntimeException {
        private JFXLibraryNotFoundException() {
        }
    }

    public static enum LoadingStep {
        INITALIZING(21),
        LOADING_CONFIGURATION(35),
        LOADING_CONSOLE(41),
        LOADING_MANAGERS(51),
        LOADING_WINDOW(62),
        PREPARING_MAINPANE(77),
        POSTINIT_GUI(82),
        REFRESHING_INFO(91),
        SUCCESS(100);

        public static final String LOADING_PREFIX = "[Loading]";
        public static final String LOADING_DELIMITER = " = ";
        private final int percentage;

        private LoadingStep(int percentage) {
            this.percentage = percentage;
        }

        public int getPercentage() {
            return this.percentage;
        }
    }
}

