/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.rmo;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import joptsimple.OptionSet;
import ru.turikhay.tlauncher.configuration.ArgumentParser;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.handlers.SimpleHostnameVerifier;
import ru.turikhay.tlauncher.managers.ComponentManager;
import ru.turikhay.tlauncher.managers.ComponentManagerListenerHelper;
import ru.turikhay.tlauncher.managers.ElyManager;
import ru.turikhay.tlauncher.managers.ProfileManager;
import ru.turikhay.tlauncher.managers.ProfileManagerListener;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.managers.ServerListManager;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorDatabase;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftLauncher;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.rmo.Bootstrapper;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.console.Console;
import ru.turikhay.tlauncher.ui.listener.MinecraftUIListener;
import ru.turikhay.tlauncher.ui.listener.RequiredUpdateListener;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.updater.AutoUpdater;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;
import ru.turikhay.util.stream.MirroredLinkedStringStream;
import ru.turikhay.util.stream.PrintLogger;

public class TLauncher {
    private static final double VERSION = 1.9;
    private static TLauncher instance;
    private static String[] sargs;
    private static File directory;
    private static PrintLogger print;
    private static Console console;
    private static Gson gson;
    private LangConfiguration lang;
    private Configuration settings;
    private Downloader downloader;
    private AutoUpdater updater;
    private TLauncherFrame frame;
    private ComponentManager manager;
    private VersionManager versionManager;
    private ProfileManager profileManager;
    private ElyManager elyManager;
    private final OptionSet args;
    private MinecraftLauncher launcher;
    private RequiredUpdateListener updateListener;
    private MinecraftUIListener minecraftListener;
    private boolean ready;
    private static final String SETTINGS = "tlauncher/ru-minecraft.properties";
    private static final String BRAND = "for Ru-Minecraft.org";
    private static final String FOLDER = "minecraft";
    private static final String[] UPDATE_REPO;
    private static final String[] OFFICIAL_REPO;
    private static final String[] EXTRA_REPO;
    private static final String[] LIBRARY_REPO;
    private static final String[] ASSETS_REPO;
    private static final String[] SERVER_LIST;

    static {
        UPDATE_REPO = new String[]{"http://ru-m.org/update/update.json"};
        OFFICIAL_REPO = new String[]{"http://s3.amazonaws.com/Minecraft.Download/"};
        EXTRA_REPO = new String[]{"http://ru-m.org/update/repo/"};
        LIBRARY_REPO = new String[]{"https://libraries.minecraft.net/"};
        ASSETS_REPO = new String[]{"http://resources.download.minecraft.net/"};
        SERVER_LIST = new String[]{"http://ru-m.org/update/servers.json"};
    }

    private TLauncher(OptionSet set) throws Exception {
        Time.start(this);
        instance = this;
        this.args = set;
        gson = new Gson();
        File oldConfig = MinecraftUtil.getSystemRelatedFile("tlauncher.cfg");
        File newConfig = MinecraftUtil.getSystemRelatedDirectory(SETTINGS);
        if (!oldConfig.isFile()) {
            oldConfig = MinecraftUtil.getSystemRelatedFile(".tlauncher/tlauncher.properties");
        }
        if (oldConfig.isFile() && !newConfig.isFile()) {
            boolean copied = true;
            try {
                FileUtil.createFile(newConfig);
                FileUtil.copyFile(oldConfig, newConfig, true);
            }
            catch (IOException ioE) {
                U.log("Cannot copy old configuration to the new place", oldConfig, newConfig, ioE);
                copied = false;
            }
            if (copied) {
                U.log("Old configuration successfully moved to the new place:", newConfig);
                FileUtil.deleteFile(oldConfig);
            }
        }
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_CONFIGURATION);
        this.settings = Configuration.createConfiguration(set);
        this.reloadLocale();
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_CONSOLE);
        console = new Console(this.settings, print, this.lang.get("console"), this.settings.getConsoleType() == Configuration.ConsoleType.GLOBAL);
        console.setCloseAction(Console.CloseAction.KILL);
        Console.updateLocale();
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_MANAGERS);
        this.manager = new ComponentManager(this);
        this.elyManager = this.manager.loadComponent(ElyManager.class);
        this.versionManager = this.manager.loadComponent(VersionManager.class);
        this.profileManager = this.manager.loadComponent(ProfileManager.class);
        this.manager.loadComponent(ServerListManager.class);
        this.manager.loadComponent(ComponentManagerListenerHelper.class);
        this.init();
        U.log("Started! (" + Time.stop(this) + " ms.)");
        this.ready = true;
        U.setLoadingStep(Bootstrapper.LoadingStep.SUCCESS);
    }

    private void init() {
        this.downloader = new Downloader(this);
        this.minecraftListener = new MinecraftUIListener(this);
        this.updater = new AutoUpdater(this);
        this.updater.asyncFindUpdate();
        U.setLoadingStep(Bootstrapper.LoadingStep.LOADING_WINDOW);
        this.frame = new TLauncherFrame(this);
        U.setLoadingStep(Bootstrapper.LoadingStep.REFRESHING_INFO);
        this.versionManager.asyncRefresh();
        this.profileManager.addListener(new ProfileManagerListener(){

            @Override
            public void onAccountsRefreshed(AuthenticatorDatabase db) {
                boolean allow = false;
                for (Account check : db.getAccounts()) {
                    allow |= check.getType() == Account.AccountType.ELY;
                }
                TLauncher.this.elyManager.setRefreshAllowed(allow);
                if (allow) {
                    TLauncher.this.elyManager.asyncRefresh();
                }
            }

            @Override
            public void onProfilesRefreshed(ProfileManager pm) {
                this.onAccountsRefreshed(pm.getAuthDatabase());
            }

            @Override
            public void onProfileManagerChanged(ProfileManager pm) {
                this.onAccountsRefreshed(pm.getAuthDatabase());
            }
        });
        this.profileManager.refresh();
        this.manager.getComponent(ServerListManager.class).asyncRefresh();
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public LangConfiguration getLang() {
        return this.lang;
    }

    public Configuration getSettings() {
        return this.settings;
    }

    public AutoUpdater getUpdater() {
        return this.updater;
    }

    public OptionSet getArguments() {
        return this.args;
    }

    public TLauncherFrame getFrame() {
        return this.frame;
    }

    public static Console getConsole() {
        return console;
    }

    public static Gson getGson() {
        return gson;
    }

    public ComponentManager getManager() {
        return this.manager;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public ElyManager getElyManager() {
        return this.elyManager;
    }

    public MinecraftLauncher getLauncher() {
        return this.launcher;
    }

    public MinecraftUIListener getMinecraftListener() {
        return this.minecraftListener;
    }

    public RequiredUpdateListener getUpdateListener() {
        return this.updateListener;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void reloadLocale() throws IOException {
        Locale locale = this.settings.getLocale();
        U.log("Selected locale: " + locale);
        if (this.lang == null) {
            this.lang = new LangConfiguration(this.settings.getLocales(), locale);
        } else {
            this.lang.setSelected(locale);
        }
        Localizable.setLang(this.lang);
        Alert.prepareLocal();
        if (console != null) {
            console.setName(this.lang.get("console"));
        }
    }

    public void launch(MinecraftListener listener, ServerList.Server server, boolean forceupdate) {
        this.launcher = new MinecraftLauncher(this, forceupdate);
        this.launcher.addListener(this.minecraftListener);
        this.launcher.addListener(listener);
        this.launcher.addListener(this.frame.mp.getProgress());
        this.launcher.setServer(server);
        this.launcher.start();
    }

    public boolean isLauncherWorking() {
        return this.launcher != null && this.launcher.isWorking();
    }

    public static void kill() {
        U.log("Good bye!");
        System.exit(0);
    }

    public void hide() {
        if (this.frame != null) {
            boolean doAgain = true;
            while (doAgain) {
                try {
                    this.frame.setVisible(false);
                    doAgain = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        U.log("I'm hiding!");
    }

    public void show() {
        if (this.frame != null) {
            boolean doAgain = true;
            while (doAgain) {
                try {
                    this.frame.setVisible(true);
                    doAgain = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        U.log("Here I am!");
    }

    public static void main(String[] args) {
        ExceptionHandler handler = ExceptionHandler.getInstance();
        Thread.setDefaultUncaughtExceptionHandler(handler);
        Thread.currentThread().setUncaughtExceptionHandler(handler);
        HttpsURLConnection.setDefaultHostnameVerifier(SimpleHostnameVerifier.getInstance());
        U.setPrefix("[TLauncher]");
        MirroredLinkedStringStream stream = new MirroredLinkedStringStream(){

            @Override
            public void flush() {
                if (console == null) {
                    try {
                        this.getMirror().flush();
                    }
                    catch (IOException iOException) {}
                } else {
                    super.flush();
                }
            }
        };
        stream.setMirror(System.out);
        print = new PrintLogger(stream);
        stream.setLogger(print);
        System.setOut(print);
        U.setLoadingStep(Bootstrapper.LoadingStep.INITALIZING);
        SwingUtil.initLookAndFeel();
        try {
            TLauncher.launch(args);
        }
        catch (Throwable e) {
            U.log("Error launching TLauncher:");
            e.printStackTrace(print);
            Alert.showError(e, true);
        }
    }

    private static void launch(String[] args) throws Exception {
        U.log("Starting TLauncher", BRAND, 1.9);
        U.log("Have question? Find my e-mail in lang files.");
        U.log("Machine info:", OS.getSummary());
        U.log("Startup time:", DateFormat.getDateTimeInstance().format(new Date()));
        U.log("---");
        sargs = args;
        new TLauncher(ArgumentParser.parseArgs(args));
    }

    public static String[] getArgs() {
        if (sargs == null) {
            sargs = new String[0];
        }
        return sargs;
    }

    public static File getDirectory() {
        if (directory == null) {
            directory = new File(".");
        }
        return directory;
    }

    public static TLauncher getInstance() {
        return instance;
    }

    public void newInstance() {
        Bootstrapper.main(sargs);
    }

    public static double getVersion() {
        return 1.9;
    }

    public static String getBrand() {
        return BRAND;
    }

    public static String getFolder() {
        return FOLDER;
    }

    public static String[] getUpdateRepos() {
        return UPDATE_REPO;
    }

    public static String getSettingsFile() {
        return SETTINGS;
    }

    public static String[] getOfficialRepo() {
        return OFFICIAL_REPO;
    }

    public static String[] getExtraRepo() {
        return EXTRA_REPO;
    }

    public static String[] getLibraryRepo() {
        return LIBRARY_REPO;
    }

    public static String[] getAssetsRepo() {
        return ASSETS_REPO;
    }

    public static String[] getServerList() {
        return SERVER_LIST;
    }
}

