/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import ru.turikhay.tlauncher.ui.SideNotifier;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.browser.BrowserHolder;
import ru.turikhay.tlauncher.ui.progress.LaunchProgress;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.scenes.PseudoScene;
import ru.turikhay.tlauncher.ui.scenes.VersionManagerScene;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import ru.turikhay.util.SwingUtil;

public class MainPane
extends ExtendedLayeredPane {
    private final TLauncherFrame rootFrame;
    private PseudoScene scene;
    public final BrowserHolder browser;
    public final LaunchProgress progress;
    public final DefaultScene defaultScene;
    public final VersionManagerScene versionManager;
    public final SideNotifier notifier;

    MainPane(TLauncherFrame frame) {
        super(null);
        this.rootFrame = frame;
        this.browser = new BrowserHolder(this);
        this.add((Component)this.browser);
        this.notifier = new SideNotifier();
        this.notifier.setLocation(10, 10);
        this.notifier.setSize(32, 32);
        this.add((Component)this.notifier);
        this.defaultScene = new DefaultScene(this);
        this.add((Component)this.defaultScene);
        this.versionManager = new VersionManagerScene(this);
        this.add((Component)this.versionManager);
        this.progress = new LaunchProgress(frame);
        this.add((Component)this.progress);
        this.setScene(this.defaultScene, false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainPane.this.onResize();
            }
        });
    }

    public PseudoScene getScene() {
        return this.scene;
    }

    public void setScene(PseudoScene scene) {
        this.setScene(scene, true);
    }

    public void setScene(PseudoScene newscene, boolean animate) {
        if (newscene == null) {
            throw new NullPointerException();
        }
        if (newscene.equals(this.scene)) {
            return;
        }
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (!comp.equals(newscene) && comp instanceof PseudoScene) {
                ((PseudoScene)comp).setShown(false, animate);
            }
            ++n2;
        }
        this.scene = newscene;
        this.scene.setShown(true);
        this.browser.setBrowserContentShown("scene", this.scene.equals(this.defaultScene));
    }

    public void openDefaultScene() {
        this.setScene(this.defaultScene);
    }

    public void openVersionManager() {
        this.setScene(this.versionManager);
    }

    public TLauncherFrame getRootFrame() {
        return this.rootFrame;
    }

    public LaunchProgress getProgress() {
        return this.progress;
    }

    @Override
    public void onResize() {
        this.browser.onResize();
        this.progress.setBounds(0, this.getHeight() - ProgressBar.DEFAULT_HEIGHT + 1, this.getWidth(), ProgressBar.DEFAULT_HEIGHT);
    }

    public Point getLocationOf(Component comp) {
        return SwingUtil.getRelativeLocation(this, comp);
    }
}

