/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.browser;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javax.xml.bind.DatatypeConverter;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.browser.BrowserBridge;
import ru.turikhay.tlauncher.ui.browser.BrowserHolder;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.Time;
import ru.turikhay.util.U;

public class BrowserPanel
extends JFXPanel
implements LocalizableComponent,
Blockable {
    private static final long serialVersionUID = 5857121254870623943L;
    private static final boolean test = false;
    private static final boolean freeSurf = false;
    private static final String pagePrefix = "http://ru-m.org/update/lch/";
    final BrowserHolder holder;
    final BrowserBridge bridge;
    private String failPage;
    private String style;
    private String scripts;
    private String background;
    private String currentDefaultPage;
    private int width;
    private int height;
    private boolean success;
    private Group group;
    private WebView view;
    private WebEngine engine;

    BrowserPanel(BrowserHolder h) throws IOException {
        this.holder = h;
        this.bridge = new BrowserBridge(this);
        this.loadResources();
        this.updateLocale();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.log(new Object[]{"Running in JavaFX Thread"});
                BrowserPanel.this.prepareFX();
                BrowserPanel.this.initBrowser();
                BrowserPanel.this.loadPage(BrowserPanel.this.currentDefaultPage);
            }
        });
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BrowserPanel.this.width = BrowserPanel.this.holder.getWidth();
                BrowserPanel.this.height = BrowserPanel.this.holder.getHeight();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (BrowserPanel.this.view != null) {
                            BrowserPanel.this.view.setPrefSize((double)BrowserPanel.this.width, (double)BrowserPanel.this.height);
                        }
                    }
                });
            }
        });
    }

    private synchronized void loadResources() throws IOException {
        BrowserPanel.log("Loading resources...");
        URL failPageResource = this.getClass().getResource("fail.html");
        this.failPage = FileUtil.getTextResource(failPageResource);
        URL styleResource = this.getClass().getResource("style.css");
        this.style = FileUtil.getTextResource(styleResource);
        URL jqueryResource = this.getClass().getResource("jquery.js");
        URL pageScriptResource = this.getClass().getResource("scripts.js");
        this.scripts = FileUtil.getTextResource(jqueryResource) + '\n' + FileUtil.getTextResource(pageScriptResource);
        URL backgroundResource = ImageCache.getRes("plains.jpg");
        byte[] backgroundImageArray = FileUtil.readFully(backgroundResource.openStream());
        BrowserPanel.log("Loading background...");
        Object timeLock = new Object();
        Time.start(timeLock);
        this.background = "page.background.setup('data:image/png;base64," + DatatypeConverter.printBase64Binary((byte[])backgroundImageArray) + "');";
        BrowserPanel.log("Background loaded in", Time.stop(timeLock), "ms.");
        BrowserPanel.log("Cleaning up after loading:");
        U.gc();
    }

    synchronized void cleanupResources() {
        BrowserPanel.log("Cleaning up resources. Memory: " + U.getUsingSpace() + " / " + U.getTotalSpace() + " MB");
        this.style = null;
        this.scripts = null;
        this.background = null;
        U.gc();
    }

    private void prepareFX() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Call this method from Platform.runLater()");
        }
        BrowserPanel.log("Preparing JavaFX...");
        Thread.currentThread().setUncaughtExceptionHandler(ExceptionHandler.getInstance());
        this.group = new Group();
        Scene scene = new Scene((Parent)this.group);
        this.setScene(scene);
    }

    private synchronized void initBrowser() {
        BrowserPanel.log("Initializing...");
        this.group.getChildren().removeAll((Object[])new Node[0]);
        this.view = new WebView();
        this.view.setContextMenuEnabled(false);
        this.view.setPrefSize((double)this.width, (double)this.height);
        final WebEngine currentEngine = this.engine = this.view.getEngine();
        this.engine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> event) {
                Alert.showMessage(currentEngine.getTitle(), (String)event.getData());
            }
        });
        this.success = true;
        this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                try {
                    BrowserPanel.this.onBrowserStateChanged(currentEngine, newValue);
                }
                catch (Throwable e) {
                    BrowserPanel.engine(currentEngine, new Object[]{"State change handle error:", e});
                }
            }
        });
        this.group.getChildren().add((Object)this.view);
    }

    private void onBrowserStateChanged(WebEngine engine, Worker.State val) {
        if (this.engine != engine) {
            return;
        }
        if (val == null) {
            throw new NullPointerException("State is NULL!");
        }
        String location = engine.getLocation();
        this.view.setMouseTransparent(true);
        switch (val) {
            case SCHEDULED: {
                BrowserPanel.page(engine, "Loading", location);
                if (location.isEmpty() || location.startsWith(pagePrefix)) break;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String last = BrowserPanel.this.getLastEntry().getUrl();
                        BrowserPanel.page(BrowserPanel.this.engine, "Last entry", last);
                        BrowserPanel.this.initBrowser();
                        BrowserPanel.this.loadPage(last);
                    }
                });
                URI uri = U.makeURI(location);
                OS.openLink(uri);
                break;
            }
            case FAILED: {
                BrowserPanel.page(engine, "Failed to load", location);
                if (!this.success) {
                    this.holder.setBrowserShown("error", false);
                    break;
                }
                this.success = false;
                this.loadContent(this.failPage);
                break;
            }
            case SUCCEEDED: {
                BrowserPanel.page(engine, "Loaded successfully", location);
                this.holder.setBrowserShown("error", true);
                this.success = true;
                Document document = engine.getDocument();
                NodeList bodies = document.getElementsByTagName("body");
                org.w3c.dom.Node body = bodies.item(0);
                if (body == null) {
                    BrowserPanel.engine(engine, "What the...? Couldn't find <body> element!");
                    break;
                }
                Element styleElement = document.createElement("style");
                styleElement.setAttribute("type", "text/css");
                styleElement.setTextContent(this.style);
                body.appendChild(styleElement);
                Element scriptElement = document.createElement("script");
                scriptElement.setAttribute("type", "text/javascript");
                scriptElement.setTextContent(this.scripts);
                body.appendChild(scriptElement);
                engine.executeScript(this.background);
                JSObject jsobj = (JSObject)engine.executeScript("window");
                jsobj.setMember("bridge", this.bridge);
                NodeList linkList = document.getElementsByTagName("a");
                int i = 0;
                while (i < linkList.getLength()) {
                    org.w3c.dom.Node linkNode = linkList.item(i);
                    EventTarget eventTarget = (EventTarget)((Object)linkNode);
                    eventTarget.addEventListener("click", new EventListener(){

                        @Override
                        public void handleEvent(Event evt) {
                            EventTarget target = evt.getCurrentTarget();
                            HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                            String href = anchorElement.getHref();
                            if (href == null || href.isEmpty() || href.startsWith("javascript:")) {
                                return;
                            }
                            URI uri = U.makeURI(href);
                            OS.openLink(uri);
                            evt.preventDefault();
                        }
                    }, false);
                    ++i;
                }
                if (Blocker.isBlocked(this)) {
                    this.block(null);
                }
                this.view.setMouseTransparent(false);
                break;
            }
        }
    }

    private WebHistory.Entry getLastEntry() {
        WebHistory hist = this.engine.getHistory();
        return (WebHistory.Entry)hist.getEntries().get(hist.getCurrentIndex());
    }

    private void loadPage(String url) {
        BrowserPanel.engine(this.engine, "Trying to load URL: \"" + url + "\"");
        this.engine.load(url);
    }

    private void loadContent(String content) {
        this.engine.loadContent(content);
    }

    void execute(String script) {
        try {
            this.engine.executeScript(script);
        }
        catch (Exception e) {
            U.log("Hidden JS exception:", e);
        }
    }

    @Override
    public void block(Object reason) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.execute("page.visibility.hide();");
            }
        });
    }

    @Override
    public void unblock(Object reason) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.execute("page.visibility.show();");
            }
        });
    }

    private static void log(Object ... o) {
        U.log("[Browser]", o);
    }

    private static void engine(WebEngine engine, Object ... o) {
        U.log("[Browser@" + engine.hashCode() + "]", o);
    }

    private static void page(WebEngine engine, String text, String page) {
        BrowserPanel.engine(engine, String.valueOf(text) + ':', String.valueOf('\"') + page + '\"');
    }

    @Override
    public void updateLocale() {
        Locale locale = TLauncher.getInstance().getSettings().getLocale();
        String oldDefaultPage = this.currentDefaultPage;
        this.currentDefaultPage = pagePrefix + (locale.equals(Locale.US) ? "eng.html" : "index.html");
        if (oldDefaultPage == null || oldDefaultPage.equals(this.currentDefaultPage)) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.loadPage(BrowserPanel.this.currentDefaultPage);
            }
        });
    }
}

