/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.ui.editor.EditorFieldChangeListener;
import ru.turikhay.tlauncher.ui.editor.EditorFieldListener;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;

public class EditorGroupHandler {
    private final List<EditorFieldChangeListener> listeners;
    private final int checkedLimit;
    private int changedFlag;
    private int checkedFlag;

    public EditorGroupHandler(List<? extends EditorHandler> handlers) {
        if (handlers == null) {
            throw new NullPointerException();
        }
        this.checkedLimit = handlers.size();
        EditorFieldListener listener = new EditorFieldListener(){

            @Override
            protected void onChange(EditorHandler handler, String oldValue, String newValue) {
                if (newValue == null) {
                    return;
                }
                if (!newValue.equals(oldValue)) {
                    EditorGroupHandler editorGroupHandler = EditorGroupHandler.this;
                    editorGroupHandler.changedFlag = editorGroupHandler.changedFlag + 1;
                }
                EditorGroupHandler editorGroupHandler = EditorGroupHandler.this;
                editorGroupHandler.checkedFlag = editorGroupHandler.checkedFlag + 1;
                if (EditorGroupHandler.this.checkedFlag == EditorGroupHandler.this.checkedLimit) {
                    if (EditorGroupHandler.this.changedFlag > 0) {
                        for (EditorFieldChangeListener listener : EditorGroupHandler.this.listeners) {
                            listener.onChange(null, null);
                        }
                    }
                    EditorGroupHandler.this.changedFlag = 0;
                    EditorGroupHandler.this.checkedFlag = 0;
                }
            }
        };
        int i = 0;
        while (i < handlers.size()) {
            EditorHandler handler = handlers.get(i);
            if (handler == null) {
                throw new NullPointerException("Handler is NULL at " + i);
            }
            handler.addListener(listener);
            ++i;
        }
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public EditorGroupHandler(EditorHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public boolean addListener(EditorFieldChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.add(listener);
    }

    public boolean removeListener(EditorFieldChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return this.listeners.remove(listener);
    }
}

