/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.editor.EditorIntegerField;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.IntegerArray;

public class EditorResolutionField
extends BorderPanel
implements EditorField {
    private static final long serialVersionUID = -5565607141889620750L;
    private EditorIntegerField w;
    private EditorIntegerField h;
    private ExtendedLabel x;
    private final LocalizableLabel hint;
    private final int[] defaults;

    public EditorResolutionField(String promptW, String promptH, int[] defaults, boolean showDefault) {
        if (defaults == null) {
            throw new NullPointerException();
        }
        if (defaults.length != 2) {
            throw new IllegalArgumentException("Illegal array size");
        }
        this.defaults = defaults;
        ExtendedPanel container = new ExtendedPanel();
        container.setAlignmentX(0.5f);
        container.setAlignmentY(0.5f);
        this.w = new EditorIntegerField(promptW);
        this.w.setColumns(4);
        this.w.setHorizontalAlignment(0);
        this.h = new EditorIntegerField(promptH);
        this.h.setColumns(4);
        this.h.setHorizontalAlignment(0);
        this.x = new ExtendedLabel("X", 0);
        container.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.weightx = 0.5;
        c.insets.set(0, 0, 0, 0);
        c.fill = 1;
        container.add((Component)this.w, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.insets.set(0, 5, 0, 5);
        c.fill = 3;
        container.add((Component)this.x, c);
        c.gridx = 2;
        c.weightx = 0.5;
        c.insets.set(0, 0, 0, 0);
        c.fill = 1;
        container.add((Component)this.h, c);
        this.setCenter(container);
        this.hint = new LocalizableHTMLLabel("settings.res.def", defaults[0], defaults[1]);
        this.hint.setFont(this.hint.getFont().deriveFont((float)this.hint.getFont().getSize() - 2.0f));
        if (showDefault) {
            this.setSouth(this.hint);
        }
    }

    @Override
    public String getSettingsValue() {
        return String.valueOf(this.w.getSettingsValue()) + ';' + this.h.getSettingsValue();
    }

    int[] getResolution() {
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(this.getSettingsValue());
            return arr.toArray();
        }
        catch (Exception e) {
            return new int[2];
        }
    }

    @Override
    public boolean isValueValid() {
        int[] size = this.getResolution();
        return size[0] >= 1 && size[1] >= 1;
    }

    @Override
    public void setSettingsValue(String value) {
        String height;
        String width;
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(value);
            width = String.valueOf(arr.get(0));
            height = String.valueOf(arr.get(1));
        }
        catch (Exception e) {
            width = "";
            height = "";
        }
        this.w.setText(width);
        this.h.setText(height);
    }

    @Override
    public void setBackground(Color bg) {
        if (this.w != null) {
            this.w.setBackground(bg);
        }
        if (this.h != null) {
            this.h.setBackground(bg);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.w, this.h);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(Blocker.UNIVERSAL_UNBLOCK, this.w, this.h);
    }
}

