/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.images;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ImageIcon
implements Icon {
    private transient Image image;
    private int width;
    private int height;
    private DisabledImageIcon disabledInstance;

    public ImageIcon(Image image, int width, int height) {
        this.setImage(image, width, height);
    }

    public ImageIcon(Image image) {
        this(image, 0, 0);
    }

    public void setImage(Image image, int preferredWidth, int preferredHeight) {
        Image scaled;
        if (image == null) {
            this.image = null;
            return;
        }
        int realWidth = image.getWidth(null);
        int realHeight = image.getHeight(null);
        this.width = preferredWidth > 0 ? preferredWidth : realWidth;
        this.height = preferredHeight > 0 ? preferredHeight : realHeight;
        this.image = scaled = image.getScaledInstance(this.width, this.height, 4);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, this.width, this.height, null);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public DisabledImageIcon getDisabledInstance() {
        if (this.disabledInstance == null) {
            this.disabledInstance = new DisabledImageIcon();
        }
        return this.disabledInstance;
    }

    public static ImageIcon setup(JLabel label, ImageIcon icon) {
        if (label == null) {
            return null;
        }
        label.setIcon(icon);
        if (icon != null) {
            label.setDisabledIcon(icon.getDisabledInstance());
        }
        return icon;
    }

    public class DisabledImageIcon
    implements Icon {
        private float disabledOpacity;
        private AlphaComposite opacityComposite;

        private DisabledImageIcon() {
            this.setDisabledOpacity(0.5f);
        }

        public float getDisabledOpacity() {
            return this.disabledOpacity;
        }

        public void setDisabledOpacity(float f) {
            this.disabledOpacity = f;
            this.opacityComposite = AlphaComposite.getInstance(3, this.disabledOpacity);
        }

        @Override
        public void paintIcon(Component c, Graphics g0, int x, int y) {
            if (ImageIcon.this.image == null) {
                return;
            }
            Graphics2D g = (Graphics2D)g0;
            Composite oldComposite = g.getComposite();
            g.setComposite(this.opacityComposite);
            g.drawImage(ImageIcon.this.image, x, y, ImageIcon.this.width, ImageIcon.this.height, null);
            g.setComposite(oldComposite);
        }

        @Override
        public int getIconWidth() {
            return ImageIcon.this.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return ImageIcon.this.getIconHeight();
        }
    }
}

