/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.loc.LocalizableTextField;
import ru.turikhay.tlauncher.ui.login.InputPanel;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;

public class UsernameField
extends LocalizableTextField
implements Blockable,
LoginForm.LoginProcessListener {
    public UsernameField(InputPanel input) {
        super("account.username");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                UsernameField.this.setBackground(UsernameField.this.getTheme().getBackground());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setValue(input.loginForm.global.get("login.account"));
    }

    public String getUsername() {
        return this.getValue();
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    @Override
    public void logginingIn() throws LoginException {
        if (this.getUsername() != null) {
            return;
        }
        this.setBackground(this.getTheme().getFailure());
        Alert.showLocError("auth.error.nousername");
        throw new LoginException("Invalid user name!");
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }
}

