/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.login.buttons;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.login.LoginForm;

public class PlayButton
extends LocalizableButton
implements Blockable,
LoginForm.LoginStateListener {
    private static final long serialVersionUID = 6944074583143406549L;
    private PlayButtonState state;
    private final LoginForm loginForm;

    public PlayButton(LoginForm lf) {
        this.loginForm = lf;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (PlayButton.this.state) {
                    case CANCEL: {
                        PlayButton.this.loginForm.stopLauncher();
                        break;
                    }
                    default: {
                        PlayButton.this.loginForm.startLauncher();
                    }
                }
            }
        });
        this.setFont(this.getFont().deriveFont(1).deriveFont(16.0f));
        this.setState(PlayButtonState.PLAY);
    }

    public PlayButtonState getState() {
        return this.state;
    }

    public void setState(PlayButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setText(state.getPath());
        if (state == PlayButtonState.CANCEL) {
            this.setEnabled(true);
        }
    }

    public void updateState() {
        VersionSyncInfo vs = this.loginForm.versions.getVersion();
        if (vs == null) {
            return;
        }
        boolean installed = vs.isInstalled();
        boolean force = this.loginForm.checkbox.forceupdate.getState();
        if (!installed) {
            this.setState(PlayButtonState.INSTALL);
        } else {
            this.setState(force ? PlayButtonState.REINSTALL : PlayButtonState.PLAY);
        }
    }

    @Override
    public void loginStateChanged(LoginForm.LoginState state) {
        if (state == LoginForm.LoginState.LAUNCHING) {
            this.setState(PlayButtonState.CANCEL);
        } else {
            this.updateState();
            this.setEnabled(!Blocker.isBlocked(this));
        }
    }

    @Override
    public void block(Object reason) {
        if (this.state != PlayButtonState.CANCEL) {
            this.setEnabled(false);
        }
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    public static enum PlayButtonState {
        REINSTALL("loginform.enter.reinstall"),
        INSTALL("loginform.enter.install"),
        PLAY("loginform.enter"),
        CANCEL("loginform.enter.cancel");

        private final String path;

        private PlayButtonState(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

