/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.progress;

import java.awt.Component;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.loc.LocalizableProgressBar;
import ru.turikhay.util.U;

public class DownloaderProgress
extends LocalizableProgressBar
implements DownloaderListener {
    private DownloaderProgress(Component parentComp, Downloader downloader) {
        super(parentComp);
        if (downloader == null) {
            throw new NullPointerException();
        }
        downloader.addListener(this);
        this.stopProgress();
    }

    public DownloaderProgress(Component parentComp) {
        this(parentComp, TLauncher.getInstance().getDownloader());
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.startProgress();
        this.setIndeterminate(true);
        this.setCenterString("progressBar.init");
        this.setEastString("progressBar.downloading", files);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        this.stopProgress();
    }

    @Override
    public void onDownloaderProgress(Downloader d, double dprogress, double speed) {
        if (dprogress > 0.0) {
            int progress = (int)(dprogress * 100.0);
            if (this.getValue() > progress) {
                return;
            }
            this.setIndeterminate(false);
            this.setValue(progress);
            this.setCenterString(String.valueOf(progress) + "%");
            this.setEastString("progressBar.remaining", d.getRemaining(), U.setFractional(speed, 1));
        }
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
        this.setIndeterminate(false);
        this.setEastString("progressBar.remaining", d.getRemaining(), U.setFractional(d.getSpeed(), 1));
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        this.stopProgress();
    }
}

