/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class SimpleListModel<E>
extends AbstractListModel<E> {
    private static final long serialVersionUID = 727845864028652893L;
    protected final Vector<E> vector = new Vector();

    @Override
    public int getSize() {
        return this.vector.size();
    }

    @Override
    public E getElementAt(int index) {
        if (index < 0 || index >= this.getSize()) {
            return null;
        }
        return this.vector.get(index);
    }

    public void add(E elem) {
        int index = this.vector.size();
        this.vector.add(elem);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean remove(E elem) {
        int index = this.indexOf(elem);
        boolean rv = this.vector.removeElement(elem);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public void addAll(Collection<E> elem) {
        int size = elem.size();
        if (size == 0) {
            return;
        }
        int index0 = this.vector.size();
        int index1 = index0 + size - 1;
        this.vector.addAll(elem);
        this.fireIntervalAdded(this, index0, index1);
    }

    public void clear() {
        int index1 = this.vector.size() - 1;
        this.vector.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public boolean contains(E elem) {
        return this.vector.contains(elem);
    }

    public int indexOf(E elem) {
        return this.vector.indexOf(elem);
    }

    public int indexOf(E elem, int index) {
        return this.vector.indexOf(elem, index);
    }

    public E elementAt(int index) {
        return this.vector.elementAt(index);
    }

    public String toString() {
        return this.vector.toString();
    }
}

