/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.versions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.minecraft.launcher.versions.Version;
import ru.turikhay.tlauncher.repository.Repository;

public enum ReleaseType {
    RELEASE("release", false, true),
    SNAPSHOT("snapshot"),
    MODIFIED("modified", true, true),
    OLD_BETA("old-beta"),
    OLD_ALPHA("old-alpha"),
    UNKNOWN("unknown", false, false);

    private static final Map<String, ReleaseType> lookup;
    private static final List<ReleaseType> defaultTypes;
    private static final List<ReleaseType> definableTypes;
    private final String name;
    private final boolean isDefinable;
    private final boolean isDefault;

    static {
        HashMap<String, ReleaseType> types = new HashMap<String, ReleaseType>(ReleaseType.values().length);
        ArrayList<ReleaseType> deflTypes = new ArrayList<ReleaseType>();
        ArrayList<ReleaseType> defnTypes = new ArrayList<ReleaseType>();
        ReleaseType[] releaseTypeArray = ReleaseType.values();
        int n = releaseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReleaseType type = releaseTypeArray[n2];
            types.put(type.getName(), type);
            if (type.isDefault()) {
                deflTypes.add(type);
            }
            if (type.isDefinable()) {
                defnTypes.add(type);
            }
            ++n2;
        }
        lookup = Collections.unmodifiableMap(types);
        defaultTypes = Collections.unmodifiableList(deflTypes);
        definableTypes = Collections.unmodifiableList(defnTypes);
    }

    private ReleaseType(String name, boolean isDefinable, boolean isDefault) {
        this.name = name;
        this.isDefinable = isDefinable;
        this.isDefault = isDefault;
    }

    private ReleaseType(String name) {
        this(name, true, false);
    }

    String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isDefinable() {
        return this.isDefinable;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static ReleaseType getByName(String name) {
        return lookup.get(name);
    }

    public static Collection<ReleaseType> valuesCollection() {
        return lookup.values();
    }

    public static List<ReleaseType> getDefault() {
        return defaultTypes;
    }

    public static List<ReleaseType> getDefinable() {
        return definableTypes;
    }

    public static enum SubType {
        OLD_RELEASE("old_release"){
            private final Date marker;
            {
                GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                calendar.set(2013, 3, 20, 15, 0);
                this.marker = calendar.getTime();
            }

            @Override
            public boolean isSubType(Version version) {
                return !version.getReleaseType().toString().startsWith("old") && version.getReleaseTime().getTime() >= 0L && version.getReleaseTime().before(this.marker);
            }
        }
        ,
        REMOTE("remote"){

            @Override
            public boolean isSubType(Version version) {
                return version.getSource() != Repository.LOCAL_VERSION_REPO;
            }
        };

        private static final Map<String, SubType> lookup;
        private static final List<SubType> defaultSubTypes;
        private final String name;
        private final boolean isDefault;

        static {
            HashMap<String, SubType> subTypes = new HashMap<String, SubType>(SubType.values().length);
            ArrayList<SubType> defSubTypes = new ArrayList<SubType>();
            SubType[] subTypeArray = SubType.values();
            int n = subTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubType subType = subTypeArray[n2];
                subTypes.put(subType.getName(), subType);
                if (subType.isDefault()) {
                    defSubTypes.add(subType);
                }
                ++n2;
            }
            lookup = Collections.unmodifiableMap(subTypes);
            defaultSubTypes = Collections.unmodifiableList(defSubTypes);
        }

        private SubType(String name, boolean isDefault) {
            this.name = name;
            this.isDefault = isDefault;
        }

        private SubType(String name) {
            this(name, true);
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public static SubType getByName(String name) {
            return lookup.get(name);
        }

        public static Collection<SubType> valuesCollection() {
            return lookup.values();
        }

        public static List<SubType> getDefault() {
            return defaultSubTypes;
        }

        public static SubType get(Version version) {
            SubType[] subTypeArray = SubType.values();
            int n = subTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubType subType = subTypeArray[n2];
                if (subType.isSubType(version)) {
                    return subType;
                }
                ++n2;
            }
            return null;
        }

        public abstract boolean isSubType(Version var1);
    }
}

