/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.downloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.GaveUpDownloadException;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.async.ExtendedThread;

public class DownloaderThread
extends ExtendedThread {
    private static final String ITERATION_BLOCK = "iteration";
    private static final int CONTAINER_SIZE = 100;
    private static final int NOTIFY_TIMER = 15000;
    private final int ID;
    private final String LOGGER_PREFIX;
    private final Downloader downloader;
    private final List<Downloadable> list;
    private final double[] averageSpeedContainer;
    private int speedCaret;
    private double currentProgress;
    private double lastProgress;
    private double doneProgress;
    private double eachProgress;
    private double speed;
    private Downloadable current;
    private boolean launched;

    DownloaderThread(Downloader d, int id) {
        super("DT#" + id);
        this.ID = id;
        this.LOGGER_PREFIX = "[D#" + id + "]";
        this.downloader = d;
        this.list = new ArrayList<Downloadable>();
        this.averageSpeedContainer = new double[100];
        this.startAndWait();
    }

    int getID() {
        return this.ID;
    }

    void add(Downloadable d) {
        this.list.add(d);
    }

    void startDownload() {
        this.launched = true;
        this.unlockThread(ITERATION_BLOCK);
    }

    void stopDownload() {
        this.launched = false;
    }

    @Override
    public void run() {
        while (true) {
            this.launched = true;
            this.eachProgress = 1.0 / (double)this.list.size();
            this.doneProgress = 0.0;
            this.currentProgress = 0.0;
            Iterator<Downloadable> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                int max;
                Downloadable d;
                this.current = d = iterator.next();
                this.onStart();
                int attempt = 0;
                Exception error = null;
                while (attempt < (max = this.downloader.getConfiguration().getTries(d.isFast()))) {
                    this.dlog("Attempting to download (repo: " + (Object)((Object)d.getRepository()) + ") [" + ++attempt + "/" + max + "]...");
                    int timeout = attempt * this.downloader.getConfiguration().getTimeout();
                    try {
                        this.download(timeout);
                        break;
                    }
                    catch (GaveUpDownloadException e) {
                        this.dlog("File is not reachable at all.");
                        error = e;
                    }
                    catch (AbortedDownloadException e) {
                        this.dlog("This download process has been aborted.");
                        error = e;
                        break;
                    }
                    if (attempt < max) continue;
                    FileUtil.deleteFile(d.getDestination());
                    for (File file : d.getAdditionalDestinations()) {
                        FileUtil.deleteFile(file);
                    }
                    this.dlog("Gave up trying to download this file.", error);
                    this.onError(error);
                }
                if (!(error instanceof AbortedDownloadException)) continue;
                this.tlog("Thread is aborting...");
                for (Downloadable downloadable : this.list) {
                    downloadable.onAbort((AbortedDownloadException)error);
                }
            }
            Arrays.fill(this.averageSpeedContainer, 0.0);
            this.list.clear();
            this.lockThread(ITERATION_BLOCK);
            this.launched = false;
        }
    }

    private void download(int timeout) throws GaveUpDownloadException, AbortedDownloadException {
        boolean hasRepo = this.current.hasRepository();
        int attempt = 0;
        int max = hasRepo ? this.current.getRepository().getCount() : 1;
        IOException cause = null;
        while (attempt < max) {
            ++attempt;
            String url = hasRepo ? String.valueOf(this.current.getRepository().getSelectedRepo()) + this.current.getURL() : this.current.getURL();
            this.dlog("Trying to download from: " + url);
            try {
                this.downloadURL(url, timeout);
                return;
            }
            catch (IOException e) {
                this.dlog("Failed to download from: " + url, e);
                cause = e;
                if (!hasRepo) continue;
                this.current.getRepository().selectNext();
            }
        }
        throw new GaveUpDownloadException(this.current, cause);
    }

    private void downloadURL(String path, int timeout) throws IOException, AbortedDownloadException, RetryDownloadException {
        long downloaded_e;
        long downloaded_s;
        URL url = new URL(path);
        URLConnection urlConnection = url.openConnection(U.getProxy());
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new IOException("Invalid protocol: " + url.getProtocol());
        }
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        Downloadable.setUp(connection, timeout, this.current.getInsertUA());
        if (!this.launched) {
            throw new AbortedDownloadException();
        }
        long reply_s = System.currentTimeMillis();
        connection.connect();
        long reply = System.currentTimeMillis() - reply_s;
        this.dlog("Got reply in " + reply + " ms.");
        BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
        File file = this.current.getDestination();
        File temp = FileUtil.makeTemp(new File(String.valueOf(file.getAbsolutePath()) + ".tlauncherdownload"));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(temp));
        long read = 0L;
        long length = connection.getContentLength();
        long speed_s = downloaded_s = System.currentTimeMillis();
        long timer = downloaded_s;
        byte[] buffer = new byte[65536];
        int curread = ((InputStream)in).read(buffer);
        while (curread > 0) {
            if (!this.launched) {
                ((OutputStream)out).close();
                throw new AbortedDownloadException();
            }
            read += (long)curread;
            ((OutputStream)out).write(buffer, 0, curread);
            curread = ((InputStream)in).read(buffer);
            if (curread == -1) break;
            long speed_e = System.currentTimeMillis() - speed_s;
            if (speed_e < 50L) continue;
            speed_s = System.currentTimeMillis();
            downloaded_e = speed_s - downloaded_s;
            double curdone = (float)read / (float)length;
            double curspeed = (double)read / (double)downloaded_e;
            if (speed_s - timer > 15000L) {
                timer = speed_s;
                this.dlog("Still downloading:", String.valueOf((int)(curdone * 100.0)) + "% at speed", U.setFractional(curspeed, 2), "kb/s");
            }
            this.onProgress(curread, curdone, curspeed);
        }
        double downloadSpeed = (downloaded_e = System.currentTimeMillis() - downloaded_s) != 0L ? (double)read / (double)downloaded_e : 0.0;
        ((InputStream)in).close();
        ((OutputStream)out).close();
        connection.disconnect();
        FileUtil.copyFile(temp, file, true);
        FileUtil.deleteFile(temp);
        List<File> copies = this.current.getAdditionalDestinations();
        if (copies.size() > 0) {
            this.dlog("Found additional destinations. Copying...");
            for (File copy : copies) {
                this.dlog("Copying " + copy + "...");
                FileUtil.copyFile(file, copy, this.current.isForce());
                this.dlog("Success!");
            }
            this.dlog("Copying completed.");
        }
        this.dlog("Downloaded in " + downloaded_e + " ms. at " + downloadSpeed + " kb/s");
        this.onComplete();
    }

    private void onStart() {
        this.current.onStart();
    }

    private void onError(Throwable e) {
        this.current.onError(e);
        this.downloader.onFileComplete(this, this.current);
    }

    private void onProgress(double curread, double curdone, double curspeed) {
        if (++this.speedCaret == 100) {
            this.speedCaret = 0;
        }
        this.averageSpeedContainer[this.speedCaret] = curspeed;
        this.currentProgress = this.doneProgress + this.eachProgress * curdone;
        if (this.currentProgress - this.lastProgress < 0.01) {
            return;
        }
        this.lastProgress = this.currentProgress;
        this.speed = U.getAverage(this.averageSpeedContainer);
        this.downloader.onProgress(this, this.currentProgress, this.speed);
    }

    private void onComplete() throws RetryDownloadException {
        this.doneProgress += this.eachProgress;
        this.current.onComplete();
        this.downloader.onProgress(this, this.doneProgress, this.speed);
        this.downloader.onFileComplete(this, this.current);
    }

    private void tlog(Object ... o) {
        U.plog(this.LOGGER_PREFIX, o);
    }

    private void dlog(Object ... o) {
        U.plog(this.LOGGER_PREFIX, "> " + this.current.getURL() + "\n ", o);
        if (this.current.hasConsole()) {
            this.current.getContainer().getConsole().log("> " + this.current.getURL() + "\n  ", o);
        }
    }
}

