/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.turikhay.tlauncher.component.ComponentDependence;
import ru.turikhay.tlauncher.component.InterruptibleComponent;
import ru.turikhay.tlauncher.component.LauncherComponent;
import ru.turikhay.tlauncher.component.RefreshableComponent;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.async.LoopedThread;

public class ComponentManager {
    private final TLauncher tlauncher;
    private final List<LauncherComponent> components;
    private final ComponentManagerRefresher refresher;

    public ComponentManager(TLauncher tlauncher) {
        if (tlauncher == null) {
            throw new NullPointerException();
        }
        this.tlauncher = tlauncher;
        this.components = Collections.synchronizedList(new ArrayList());
        this.refresher = new ComponentManagerRefresher(this);
        this.refresher.start();
    }

    public TLauncher getLauncher() {
        return this.tlauncher;
    }

    public <T extends LauncherComponent> T loadComponent(Class<T> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException();
        }
        if (this.hasComponent(classOfT)) {
            return this.getComponent(classOfT);
        }
        ComponentDependence dependence = classOfT.getAnnotation(ComponentDependence.class);
        if (dependence != null) {
            Class<?>[] classArray = dependence.value();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> requiredClass = classArray[n2];
                this.rawLoadComponent(requiredClass);
                ++n2;
            }
        }
        return (T)((LauncherComponent)this.rawLoadComponent(classOfT));
    }

    private <T> T rawLoadComponent(Class<T> classOfT) {
        T instance;
        Constructor<T> constructor;
        if (classOfT == null) {
            throw new NullPointerException();
        }
        if (!LauncherComponent.class.isAssignableFrom(classOfT)) {
            throw new IllegalArgumentException("Given class is not a LauncherComponent: " + classOfT.getSimpleName());
        }
        try {
            constructor = classOfT.getConstructor(ComponentManager.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get constructor for component: " + classOfT.getSimpleName(), e);
        }
        try {
            instance = constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create a new instance for component: " + classOfT.getSimpleName(), e);
        }
        LauncherComponent component = (LauncherComponent)instance;
        this.components.add(component);
        return instance;
    }

    public <T extends LauncherComponent> T getComponent(Class<T> classOfT) {
        if (classOfT == null) {
            throw new NullPointerException();
        }
        for (LauncherComponent component : this.components) {
            if (!classOfT.isInstance(component)) continue;
            return (T)component;
        }
        throw new IllegalArgumentException("Cannot find the component!");
    }

    <T extends LauncherComponent> boolean hasComponent(Class<T> classOfT) {
        if (classOfT == null) {
            return false;
        }
        for (LauncherComponent component : this.components) {
            if (!classOfT.isInstance(component)) continue;
            return true;
        }
        return false;
    }

    public <T> List<T> getComponentsOf(Class<T> classOfE) {
        ArrayList<LauncherComponent> list = new ArrayList<LauncherComponent>();
        if (classOfE == null) {
            return list;
        }
        for (LauncherComponent component : this.components) {
            if (!classOfE.isInstance(component)) continue;
            list.add(component);
        }
        return list;
    }

    public void startAsyncRefresh() {
        this.refresher.iterate();
    }

    void startRefresh() {
        for (LauncherComponent component : this.components) {
            if (!(component instanceof RefreshableComponent)) continue;
            RefreshableComponent interruptible = (RefreshableComponent)component;
            interruptible.refreshComponent();
        }
    }

    public void stopRefresh() {
        for (LauncherComponent component : this.components) {
            if (!(component instanceof InterruptibleComponent)) continue;
            InterruptibleComponent interruptible = (InterruptibleComponent)component;
            interruptible.stopRefresh();
        }
    }

    class ComponentManagerRefresher
    extends LoopedThread {
        private final ComponentManager parent;

        ComponentManagerRefresher(ComponentManager manager) {
            super("ComponentManagerRefresher");
            this.parent = manager;
        }

        @Override
        protected void iterateOnce() {
            this.parent.startRefresh();
        }
    }
}

