/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.Image;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.listener.UpdateUIListener;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.swing.ImagePanel;
import ru.turikhay.tlauncher.updater.Update;
import ru.turikhay.tlauncher.updater.Updater;
import ru.turikhay.tlauncher.updater.UpdaterListener;

public class SideNotifier
extends ImagePanel
implements UpdaterListener {
    private static final String LANG_PREFIX = "notifier.";
    private NotifierStatus status;
    private Update update;

    public SideNotifier() {
        super((Image)null, 1.0f, 0.75f, false, true);
        TLauncher.getInstance().getUpdater().addListener(this);
    }

    public NotifierStatus getStatus() {
        return this.status;
    }

    public void setStatus(NotifierStatus status) {
        if (status == null) {
            throw new NullPointerException();
        }
        this.status = status;
        this.setImage(status.getImage());
        if (status == NotifierStatus.NONE) {
            this.hide();
        } else {
            this.show();
        }
    }

    @Override
    protected boolean onClick() {
        boolean result = this.processClick();
        if (result) {
            this.hide();
        }
        return result;
    }

    private boolean processClick() {
        if (!super.onClick()) {
            return false;
        }
        switch (this.status) {
            case FAILED: {
                Alert.showWarning(Localizable.get("notifier.failed.title"), Localizable.get("notifier.failed"));
                break;
            }
            case FOUND: {
                if (this.update == null) {
                    throw new IllegalStateException("Update is NULL!");
                }
                String prefix = LANG_PREFIX + this.status.toString() + ".";
                String title = String.valueOf(prefix) + "title";
                String question = String.valueOf(prefix) + "question";
                boolean ask = Alert.showQuestion(Localizable.get(title), Localizable.get(question, this.update.getVersion()), this.update.getDescription());
                if (!ask) {
                    return false;
                }
                UpdateUIListener listener = new UpdateUIListener(this.update);
                listener.push();
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status: " + (Object)((Object)this.status));
            }
        }
        return true;
    }

    @Override
    public void onUpdaterRequesting(Updater u) {
        this.setFoundUpdate(null);
    }

    @Override
    public void onUpdaterErrored(Updater.SearchFailed failed) {
        this.setStatus(NotifierStatus.FAILED);
    }

    @Override
    public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
        Update update = succeeded.getResponse().getUpdate();
        this.setFoundUpdate(update.isApplicable() ? update : null);
    }

    private void setFoundUpdate(Update upd) {
        this.update = upd;
        this.setStatus(upd == null ? NotifierStatus.NONE : NotifierStatus.FOUND);
    }

    public static enum NotifierStatus {
        FAILED("warning.png"),
        FOUND("down32.png"),
        NONE;

        private final Image image;

        private NotifierStatus(String imagePath) {
            this.image = imagePath == null ? null : ImageCache.getImage(imagePath);
        }

        private NotifierStatus() {
            this(null);
        }

        public Image getImage() {
            return this.image;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

