/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.accounts;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.accounts.UsernameField;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableRadioButton;
import ru.turikhay.tlauncher.ui.progress.ProgressBar;
import ru.turikhay.tlauncher.ui.scenes.AccountEditorScene;
import ru.turikhay.tlauncher.ui.swing.CheckBoxListener;
import ru.turikhay.tlauncher.ui.text.ExtendedPasswordField;

public class AccountEditor
extends CenterPanel {
    private static final String passlock = "passlock";
    private final AccountEditorScene scene;
    public final UsernameField username;
    public final BlockablePasswordField password;
    public final ButtonGroup authGroup;
    public final AuthTypeRadio freeAuth;
    public final AuthTypeRadio mojangAuth;
    public final AuthTypeRadio elyAuth;
    public final LinkedHashMap<Account.AccountType, AuthTypeRadio> radioMap = new LinkedHashMap();
    public final LocalizableButton save;
    private final ProgressBar progressBar;

    public AccountEditor(AccountEditorScene sc) {
        super(squareInsets);
        this.scene = sc;
        ActionListener enterHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountEditor.this.defocus();
                ((AccountEditor)AccountEditor.this).scene.handler.saveEditor();
            }
        };
        this.username = new UsernameField((CenterPanel)this, UsernameField.UsernameState.USERNAME);
        this.username.addActionListener(enterHandler);
        this.password = new BlockablePasswordField();
        this.password.addActionListener(enterHandler);
        this.password.setEnabled(false);
        this.authGroup = new ButtonGroup();
        this.freeAuth = new AuthTypeRadio(Account.AccountType.FREE);
        this.mojangAuth = new AuthTypeRadio(Account.AccountType.MOJANG);
        this.elyAuth = new AuthTypeRadio(Account.AccountType.ELY);
        this.save = new LocalizableButton("account.save");
        this.save.addActionListener(enterHandler);
        this.progressBar = new ProgressBar();
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        this.add((Component)this.del(0));
        this.add((Component)AccountEditor.sepPan(this.username));
        this.add((Component)AccountEditor.sepPan(this.freeAuth, this.mojangAuth, this.elyAuth));
        this.add((Component)AccountEditor.sepPan(this.password));
        this.add((Component)this.del(0));
        this.add((Component)AccountEditor.sepPan(this.save));
        this.add((Component)AccountEditor.sepPan(this.progressBar));
    }

    public Account.AccountType getSelectedAccountType() {
        for (Map.Entry<Account.AccountType, AuthTypeRadio> en : this.radioMap.entrySet()) {
            if (!en.getValue().isSelected()) continue;
            return en.getKey();
        }
        return Account.AccountType.FREE;
    }

    public void setSelectedAccountType(Account.AccountType type) {
        AuthTypeRadio selectable = this.radioMap.get((Object)type);
        if (selectable != null) {
            selectable.setSelected(true);
        }
    }

    public void fill(Account account) {
        this.setSelectedAccountType(account.getType());
        this.username.setText(account.getUsername());
        this.password.setText(null);
    }

    public void clear() {
        this.setSelectedAccountType(null);
        this.username.setText(null);
        this.password.setText(null);
    }

    public Account get() {
        Account account = new Account();
        account.setUsername(this.username.getValue());
        Account.AccountType type = this.getSelectedAccountType();
        switch (type) {
            case ELY: 
            case MOJANG: {
                if (!this.password.hasPassword()) break;
                account.setPassword(this.password.getPassword());
                break;
            }
        }
        account.setType(type);
        return account;
    }

    @Override
    public Insets getInsets() {
        return squareInsets;
    }

    @Override
    public void block(Object reason) {
        super.block(reason);
        if (!reason.equals("empty")) {
            this.progressBar.setIndeterminate(true);
        }
    }

    @Override
    public void unblock(Object reason) {
        super.unblock(reason);
        if (!reason.equals("empty")) {
            this.progressBar.setIndeterminate(false);
        }
    }

    public class AuthTypeRadio
    extends LocalizableRadioButton {
        private final Account.AccountType type;

        private AuthTypeRadio(final Account.AccountType type) {
            super("account.auth." + type.toString());
            AccountEditor.this.radioMap.put(type, this);
            AccountEditor.this.authGroup.add(this);
            this.type = type;
            final boolean free = type == Account.AccountType.FREE;
            this.addItemListener(new CheckBoxListener(){

                @Override
                public void itemStateChanged(boolean newstate) {
                    if (newstate && !((AuthTypeRadio)AuthTypeRadio.this).AccountEditor.this.password.hasPassword()) {
                        ((AuthTypeRadio)AuthTypeRadio.this).AccountEditor.this.password.setText(null);
                    }
                    if (newstate) {
                        ((AccountEditor)((AuthTypeRadio)AuthTypeRadio.this).AccountEditor.this).scene.tip.setAccountType(type);
                    }
                    Blocker.setBlocked(((AuthTypeRadio)AuthTypeRadio.this).AccountEditor.this.password, AccountEditor.passlock, newstate &= free);
                    ((AuthTypeRadio)AuthTypeRadio.this).AccountEditor.this.username.setState(newstate ? UsernameField.UsernameState.USERNAME : UsernameField.UsernameState.EMAIL);
                    AccountEditor.this.defocus();
                }
            });
        }

        public Account.AccountType getAccountType() {
            return this.type;
        }
    }

    private class BlockablePasswordField
    extends ExtendedPasswordField
    implements Blockable {
        private BlockablePasswordField() {
        }

        @Override
        public void block(Object reason) {
            this.setEnabled(false);
        }

        @Override
        public void unblock(Object reason) {
            this.setEnabled(true);
        }
    }
}

