/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.alert;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ru.turikhay.tlauncher.ui.alert.AlertPanel;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.U;

public class Alert {
    private static final JFrame frame = new JFrame();
    private static final String PREFIX = "TLauncher : ";
    private static final String MISSING_TITLE = "MISSING TITLE";
    private static final String MISSING_MESSAGE = "MISSING MESSAGE";
    private static final String MISSING_QUESTION = "MISSING QUESTION";
    private static String DEFAULT_TITLE = "An error occurred";
    private static String DEFAULT_MESSAGE = "An unexpected error occurred";

    public static void showError(String title, String message, Object textarea) {
        if (textarea instanceof Throwable) {
            U.log("Showing error:", textarea);
        }
        Alert.showMonolog(0, title, message, textarea);
    }

    public static void showError(String title, String message) {
        Alert.showError(title, message, null);
    }

    public static void showError(String message, Object textarea) {
        Alert.showError(DEFAULT_TITLE, message, textarea);
    }

    public static void showError(Object textarea, boolean exit) {
        Alert.showError(DEFAULT_TITLE, DEFAULT_MESSAGE, textarea);
        if (exit) {
            System.exit(-1);
        }
    }

    public static void showError(Object textarea) {
        Alert.showError(textarea, false);
    }

    public static void showLocError(String titlePath, String messagePath, Object textarea) {
        Alert.showError(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(messagePath, MISSING_MESSAGE), textarea);
    }

    public static void showLocError(String path, Object textarea) {
        Alert.showError(Alert.getLoc(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE), textarea);
    }

    public static void showLocError(String path) {
        Alert.showLocError(path, null);
    }

    public static void showMessage(String title, String message, Object textarea) {
        Alert.showMonolog(1, title, message, textarea);
    }

    public static void showMessage(String title, String message) {
        Alert.showMessage(title, message, null);
    }

    public static void showLocMessage(String titlePath, String messagePath, Object textarea) {
        Alert.showMessage(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(messagePath, MISSING_MESSAGE), textarea);
    }

    public static void showLocMessage(String path, Object textarea) {
        Alert.showMessage(Alert.getLoc(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE), textarea);
    }

    public static void showLocMessage(String path) {
        Alert.showLocMessage(path, null);
    }

    public static void showWarning(String title, String message, Object textarea) {
        Alert.showMonolog(2, title, message, textarea);
    }

    public static void showWarning(String title, String message) {
        Alert.showWarning(title, message, null);
    }

    public static void showLocWarning(String titlePath, String messagePath, Object textarea) {
        Alert.showWarning(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(messagePath, MISSING_MESSAGE), textarea);
    }

    private static void showLocWarning(String titlePath, String messagePath) {
        Alert.showLocWarning(titlePath, messagePath, null);
    }

    public static void showLocWarning(String path, Object textarea) {
        Alert.showWarning(Alert.getLoc(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_MESSAGE), textarea);
    }

    public static void showLocWarning(String path) {
        Alert.showLocWarning(path, null);
    }

    public static boolean showQuestion(String title, String question, Object textarea) {
        return Alert.showConfirmDialog(0, 3, title, question, textarea) == 0;
    }

    public static boolean showQuestion(String title, String question) {
        return Alert.showQuestion(title, question, null);
    }

    public static boolean showLocQuestion(String titlePath, String questionPath, Object textarea) {
        return Alert.showQuestion(Alert.getLoc(titlePath, MISSING_TITLE), Alert.getLoc(questionPath, MISSING_QUESTION), textarea);
    }

    public static boolean showLocQuestion(String titlePath, String questionPath) {
        return Alert.showQuestion(titlePath, questionPath, null);
    }

    public static boolean showLocQuestion(String path, Object textarea) {
        return Alert.showQuestion(Alert.getLoc(String.valueOf(path) + ".title", MISSING_TITLE), Alert.getLoc(path, MISSING_QUESTION), textarea);
    }

    public static boolean showLocQuestion(String path) {
        return Alert.showLocQuestion(path, null);
    }

    private static void showMonolog(int messageType, String title, String message, Object textarea) {
        JOptionPane.showMessageDialog(frame, new AlertPanel(message, textarea), Alert.getTitle(title), messageType);
    }

    private static int showConfirmDialog(int optionType, int messageType, String title, String message, Object textarea) {
        return JOptionPane.showConfirmDialog(frame, new AlertPanel(message, textarea), Alert.getTitle(title), optionType, messageType);
    }

    public static void prepareLocal() {
        DEFAULT_TITLE = Alert.getLoc("alert.error.title", DEFAULT_TITLE);
        DEFAULT_MESSAGE = Alert.getLoc("alert.error.message", DEFAULT_MESSAGE);
    }

    private static String getTitle(String title) {
        return PREFIX + (title == null ? MISSING_TITLE : title);
    }

    private static String getLoc(String path, String fallbackMessage) {
        String result = Localizable.get(path);
        return result == null ? fallbackMessage : result;
    }
}

