/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import ru.turikhay.tlauncher.ui.converter.StringConverter;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedComboBox;

public class EditorComboBox<T>
extends ExtendedComboBox<T>
implements EditorField {
    private static final long serialVersionUID = -2320340434786516374L;
    private final boolean allowNull;

    public EditorComboBox(StringConverter<T> converter, T[] values, boolean allowNull) {
        super(converter);
        this.allowNull = allowNull;
        if (values == null) {
            return;
        }
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            this.addItem(value);
            ++n2;
        }
    }

    public EditorComboBox(StringConverter<T> converter, T[] values) {
        this(converter, values, false);
    }

    @Override
    public String getSettingsValue() {
        Object value = this.getSelectedValue();
        return this.convert(value);
    }

    @Override
    public void setSettingsValue(String string) {
        Object value = this.convert(string);
        if (!this.allowNull && string == null) {
            boolean hasNull = false;
            int i = 0;
            while (i < this.getItemCount()) {
                if (this.getItemAt(i) == null) {
                    hasNull = true;
                }
                ++i;
            }
            if (!hasNull) {
                return;
            }
        }
        this.setSelectedValue(value);
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

