/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import ru.turikhay.tlauncher.ui.editor.AbstractEditorPanel;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;
import ru.turikhay.tlauncher.ui.editor.EditorPair;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.VPanel;

public class EditorPanel
extends AbstractEditorPanel {
    private static final long serialVersionUID = 3428243378644563729L;
    protected final ExtendedPanel container = new ExtendedPanel();
    protected final ScrollPane scroll;
    private final List<ExtendedPanel> panels;
    private final List<GridBagConstraints> constraints;
    protected final List<EditorHandler> handlers;
    private byte paneNum;
    private byte rowNum;

    public EditorPanel(Insets insets) {
        super(insets);
        this.container.setLayout(new BoxLayout(this.container, 3));
        this.panels = new ArrayList<ExtendedPanel>();
        this.constraints = new ArrayList<GridBagConstraints>();
        this.handlers = new ArrayList<EditorHandler>();
        this.scroll = new ScrollPane(this.container);
        this.add((Component)this.messagePanel, (Component)this.scroll);
    }

    public EditorPanel() {
        this(smallSquareNoTopInsets);
    }

    protected void add(EditorPair pair) {
        GridBagConstraints c;
        ExtendedPanel panel;
        LocalizableLabel label = pair.getLabel();
        VPanel field = pair.getPanel();
        if (this.paneNum == this.panels.size()) {
            panel = new ExtendedPanel(new GridBagLayout());
            panel.getInsets().set(0, 0, 0, 0);
            c = new GridBagConstraints();
            c.fill = 2;
            this.container.add((Component)panel, (Component)this.del(0));
            this.panels.add(panel);
            this.constraints.add(c);
        } else {
            panel = this.panels.get(this.paneNum);
            c = this.constraints.get(this.paneNum);
        }
        c.anchor = 17;
        c.gridy = this.rowNum;
        c.gridx = 0;
        c.weightx = 0.1;
        panel.add((Component)label, c);
        c.anchor = 13;
        byte by = this.rowNum;
        this.rowNum = (byte)(by + 1);
        c.gridy = by;
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)field, c);
        this.handlers.addAll(pair.getHandlers());
    }

    protected void nextPane() {
        this.rowNum = 0;
        this.paneNum = (byte)(this.paneNum + 1);
    }
}

