/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import ru.turikhay.tlauncher.ui.center.CenterPanelTheme;
import ru.turikhay.tlauncher.ui.editor.AbstractEditorPanel;
import ru.turikhay.tlauncher.ui.editor.EditorPair;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.Del;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.swing.extended.TabbedPane;
import ru.turikhay.tlauncher.ui.swing.extended.VPanel;

public class TabbedEditorPanel
extends AbstractEditorPanel {
    protected final BorderPanel container;
    protected final TabbedPane tabPane;
    protected final List<EditorPanelTab> tabs = new ArrayList<EditorPanelTab>();

    public TabbedEditorPanel(CenterPanelTheme theme, Insets insets) {
        super(theme, insets);
        this.tabPane = new TabbedPane();
        if (this.tabPane.getExtendedUI() != null) {
            this.tabPane.getExtendedUI().setTheme(this.getTheme());
        }
        this.container = new BorderPanel();
        this.container.setNorth(this.messagePanel);
        this.container.setCenter(this.tabPane);
        this.setLayout(new BorderLayout());
        super.add((Component)this.container, "Center");
    }

    public TabbedEditorPanel(CenterPanelTheme theme) {
        this(theme, null);
    }

    public TabbedEditorPanel(Insets insets) {
        this(null, insets);
    }

    public TabbedEditorPanel() {
        this(smallSquareNoTopInsets);
    }

    protected void add(EditorPanelTab tab) {
        if (tab == null) {
            throw new NullPointerException("tab is null");
        }
        this.tabPane.addTab(tab.getTabName(), tab.getTabIcon(), tab.getScroll(), tab.getTabTip());
        this.tabs.add(tab);
    }

    protected void remove(EditorPanelTab tab) {
        if (tab == null) {
            throw new NullPointerException("tab is null");
        }
        int index = this.tabs.indexOf(tab);
        if (index != -1) {
            this.tabPane.removeTabAt(index);
            this.tabs.remove(index);
        }
    }

    protected int getTabOf(EditorPair pair) {
        return this.tabPane.indexOfComponent(pair.getPanel());
    }

    @Override
    protected Del del(int aligment) {
        Color border;
        try {
            border = this.tabPane.getExtendedUI().getTheme().getBorder();
        }
        catch (Exception e) {
            border = this.getTheme().getBorder();
        }
        return new Del(1, aligment, border);
    }

    public class EditorPanelTab
    extends ExtendedPanel
    implements LocalizableComponent {
        private final String name;
        private final String tip;
        private final Icon icon;
        private final List<ExtendedPanel> panels;
        private final List<GridBagConstraints> constraints;
        private byte paneNum;
        private byte rowNum;
        private final EditorScrollPane scroll;
        private boolean savingEnabled = true;

        public EditorPanelTab(String name, String tip, Icon icon) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            this.name = name;
            this.tip = tip;
            this.icon = icon;
            this.panels = new ArrayList<ExtendedPanel>();
            this.constraints = new ArrayList<GridBagConstraints>();
            this.setLayout(new BoxLayout(this, 3));
            this.setInsets(0, 10, 0, 10);
            this.scroll = new EditorScrollPane(this);
        }

        public EditorPanelTab(String name) {
            this(name, null, null);
        }

        public String getTabName() {
            return Localizable.get(this.name);
        }

        public Icon getTabIcon() {
            return this.icon;
        }

        public String getTabTip() {
            return Localizable.get(this.tip);
        }

        public EditorScrollPane getScroll() {
            return this.scroll;
        }

        public boolean getSavingEnabled() {
            return this.savingEnabled;
        }

        public void setSavingEnabled(boolean b) {
            this.savingEnabled = b;
        }

        public void add(EditorPair pair) {
            GridBagConstraints c;
            ExtendedPanel panel;
            LocalizableLabel label = pair.getLabel();
            VPanel field = pair.getPanel();
            if (this.paneNum == this.panels.size()) {
                panel = new ExtendedPanel(new GridBagLayout());
                panel.getInsets().set(0, 0, 0, 0);
                c = new GridBagConstraints();
                c.fill = 2;
                this.add((Component)panel, (Component)TabbedEditorPanel.this.del(0));
                this.panels.add(panel);
                this.constraints.add(c);
            } else {
                panel = this.panels.get(this.paneNum);
                c = this.constraints.get(this.paneNum);
            }
            c.anchor = 17;
            c.gridy = this.rowNum;
            c.gridx = 0;
            c.weightx = 0.1;
            panel.add((Component)label, c);
            c.anchor = 13;
            byte by = this.rowNum;
            this.rowNum = (byte)(by + 1);
            c.gridy = by;
            c.gridx = 1;
            c.weightx = 1.0;
            panel.add((Component)field, c);
            TabbedEditorPanel.this.handlers.addAll(pair.getHandlers());
        }

        public void nextPane() {
            this.rowNum = 0;
            this.paneNum = (byte)(this.paneNum + 1);
        }

        @Override
        public void updateLocale() {
            int index = TabbedEditorPanel.this.tabPane.indexOfComponent(this.scroll);
            if (index == -1) {
                throw new RuntimeException("Cannot find scroll component in tabPane for tab: " + this.name);
            }
            TabbedEditorPanel.this.tabPane.setTitleAt(index, this.getTabName());
            TabbedEditorPanel.this.tabPane.setToolTipTextAt(index, this.getTabTip());
        }
    }

    public class EditorScrollPane
    extends ScrollPane {
        private final EditorPanelTab tab;

        EditorScrollPane(EditorPanelTab tab) {
            super(tab);
            this.tab = tab;
        }

        public EditorPanelTab getTab() {
            return this.tab;
        }
    }
}

