/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.io.IOException;
import java.io.StringReader;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.editor.EditorPane;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.git.ITokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;

public class HTMLPage
extends BorderPanel
implements LocalizableComponent {
    private final AboutPageTokenResolver resolver;
    private final String source;
    private final EditorPane editor;

    HTMLPage(String resourceName) {
        String tempSource;
        try {
            tempSource = FileUtil.getResource(this.getClass().getResource(resourceName));
        }
        catch (Exception e) {
            U.log(e);
            tempSource = null;
        }
        this.source = tempSource;
        this.resolver = new AboutPageTokenResolver();
        this.editor = new EditorPane();
        this.updateLocale();
        this.setCenter(this.editor);
    }

    public EditorPane getEditor() {
        return this.editor;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public void updateLocale() {
        if (this.source == null) {
            return;
        }
        StringBuilder string = new StringBuilder();
        TokenReplacingReader replacer = new TokenReplacingReader(new StringReader(this.source), this.resolver);
        try {
            try {
                int read;
                while ((read = replacer.read()) > 0) {
                    string.append((char)read);
                }
            }
            catch (IOException ioE) {
                ioE.printStackTrace();
                U.close(replacer);
                return;
            }
        }
        finally {
            U.close(replacer);
        }
        this.editor.setText(string.toString());
    }

    private class AboutPageTokenResolver
    implements ITokenResolver {
        private static final String image = "image:";
        private static final String loc = "loc:";
        private static final String color = "color";

        private AboutPageTokenResolver() {
        }

        @Override
        public String resolveToken(String token) {
            if (token.startsWith(image)) {
                return ImageCache.getRes(token.substring(image.length())).toExternalForm();
            }
            if (token.startsWith(loc)) {
                return Localizable.get(token.substring(loc.length()));
            }
            if (token.equals(color)) {
                return "black";
            }
            return token;
        }
    }
}

