/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSlider;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.editor.EditorField;
import ru.turikhay.tlauncher.ui.editor.EditorIntegerField;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.loc.LocalizableHTMLLabel;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.OS;

public class SettingsMemorySlider
extends BorderPanel
implements EditorField {
    private final JSlider slider = new JSlider();
    private final EditorIntegerField inputField;
    private final LocalizableLabel mb;
    private final LocalizableLabel hint;

    SettingsMemorySlider() {
        this.slider.setOpaque(false);
        this.slider.setMinimum(512);
        this.slider.setMaximum(OS.Arch.MAX_MEMORY);
        this.slider.setMinorTickSpacing(OS.Arch.x64.isCurrent() ? 256 : 128);
        this.slider.setMajorTickSpacing(512);
        this.slider.setSnapToTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SettingsMemorySlider.this.requestFocusInWindow();
            }
        });
        this.setCenter(this.slider);
        this.inputField = new EditorIntegerField();
        this.inputField.setColumns(5);
        this.mb = new LocalizableLabel("settings.java.memory.mb");
        ExtendedPanel panel = new ExtendedPanel();
        panel.add((Component)this.inputField, (Component)this.mb);
        this.setEast(panel);
        this.hint = new LocalizableHTMLLabel("");
        this.setSouth(this.hint);
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SettingsMemorySlider.this.onSliderUpdate();
            }
        });
        this.slider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SettingsMemorySlider.this.onSliderUpdate();
            }
        });
        this.inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsMemorySlider.this.updateInfo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    @Override
    public void setBackground(Color color) {
        if (this.inputField != null) {
            this.inputField.setBackground(color);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.slider, this.inputField, this.hint);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(reason, this.slider, this.inputField, this.hint);
    }

    @Override
    public String getSettingsValue() {
        return this.inputField.getValue();
    }

    @Override
    public void setSettingsValue(String value) {
        this.inputField.setValue((Object)value);
        this.updateInfo();
    }

    @Override
    public boolean isValueValid() {
        return this.inputField.getIntegerValue() >= 512;
    }

    private void onSliderUpdate() {
        this.inputField.setValue(this.slider.getValue());
        this.updateTip();
    }

    private void updateSlider() {
        int intVal = this.inputField.getIntegerValue();
        if (intVal > 1) {
            this.slider.setValue(intVal);
        }
    }

    private void updateTip() {
        ImageIcon icon;
        String path;
        int intVal = this.inputField.getIntegerValue();
        ValueType value = null;
        if (intVal < 512) {
            value = ValueType.DANGER;
        } else if (intVal == OS.Arch.PREFERRED_MEMORY) {
            value = ValueType.OK;
        } else {
            switch (OS.Arch.CURRENT) {
                case x64: {
                    if (OS.Arch.TOTAL_RAM_MB > 0L && (long)intVal > OS.Arch.TOTAL_RAM_MB) {
                        value = ValueType.DANGER;
                        break;
                    }
                    if (intVal <= OS.Arch.MAX_MEMORY) break;
                    value = ValueType.WARNING;
                    break;
                }
                default: {
                    if (intVal > OS.Arch.MAX_MEMORY) {
                        value = ValueType.DANGER;
                        break;
                    }
                    if (intVal <= OS.Arch.PREFERRED_MEMORY) break;
                    value = ValueType.WARNING;
                }
            }
        }
        if (value == null) {
            path = "";
            icon = null;
        } else {
            path = value.path;
            icon = value.icon;
        }
        this.hint.setText(path);
        ImageIcon.setup(this.hint, icon);
    }

    private void updateInfo() {
        this.updateSlider();
        this.updateTip();
    }

    private static enum ValueType {
        OK("info.png"),
        WARNING("warning.png"),
        DANGER("danger.png");

        private final String path = "settings.java.memory.hint." + this.toString().toLowerCase();
        private final ImageIcon icon;

        private ValueType(String image) {
            this.icon = ImageCache.getIcon(image, 16, 16);
        }
    }
}

