/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.settings;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.minecraft.launcher.versions.ReleaseType;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.managers.VersionLists;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.converter.ActionOnLaunchConverter;
import ru.turikhay.tlauncher.ui.converter.ConnectionQualityConverter;
import ru.turikhay.tlauncher.ui.converter.ConsoleTypeConverter;
import ru.turikhay.tlauncher.ui.converter.LocaleConverter;
import ru.turikhay.tlauncher.ui.editor.EditorCheckBox;
import ru.turikhay.tlauncher.ui.editor.EditorComboBox;
import ru.turikhay.tlauncher.ui.editor.EditorFieldChangeListener;
import ru.turikhay.tlauncher.ui.editor.EditorFieldHandler;
import ru.turikhay.tlauncher.ui.editor.EditorFileField;
import ru.turikhay.tlauncher.ui.editor.EditorGroupHandler;
import ru.turikhay.tlauncher.ui.editor.EditorHandler;
import ru.turikhay.tlauncher.ui.editor.EditorPair;
import ru.turikhay.tlauncher.ui.editor.EditorResolutionField;
import ru.turikhay.tlauncher.ui.editor.EditorTextField;
import ru.turikhay.tlauncher.ui.editor.TabbedEditorPanel;
import ru.turikhay.tlauncher.ui.explorer.FileExplorer;
import ru.turikhay.tlauncher.ui.loc.LocalizableButton;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.login.LoginException;
import ru.turikhay.tlauncher.ui.login.LoginForm;
import ru.turikhay.tlauncher.ui.scenes.DefaultScene;
import ru.turikhay.tlauncher.ui.settings.SettingsMemorySlider;
import ru.turikhay.tlauncher.ui.swing.ImageButton;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.util.OS;

public class SettingsPanel
extends TabbedEditorPanel
implements LoginForm.LoginProcessListener,
LocalizableComponent {
    private final DefaultScene scene;
    private final TabbedEditorPanel.EditorPanelTab minecraftTab;
    public final EditorFieldHandler directory;
    public final EditorFieldHandler resolution;
    public final EditorFieldHandler fullscreen;
    public final EditorFieldHandler javaArgs;
    public final EditorFieldHandler mcArgs;
    public final EditorFieldHandler javaPath;
    public final EditorFieldHandler memory;
    public final EditorGroupHandler versionHandler;
    private final TabbedEditorPanel.EditorPanelTab tlauncherTab;
    public final EditorFieldHandler console;
    public final EditorFieldHandler fullCommand;
    public final EditorFieldHandler connQuality;
    public final EditorFieldHandler launchAction;
    public final EditorFieldHandler locale;
    private final BorderPanel buttonPanel;
    private final LocalizableButton saveButton;
    private final LocalizableButton defaultButton;
    private final ImageButton homeButton;
    private final JPopupMenu popup;
    private final LocalizableMenuItem infoItem;
    private final LocalizableMenuItem defaultItem;
    private EditorHandler selectedHandler;

    public SettingsPanel(DefaultScene sc) {
        super(tipTheme, new Insets(5, 10, 10, 10));
        if (this.tabPane.getExtendedUI() != null) {
            this.tabPane.getExtendedUI().setTheme(settingsTheme);
        }
        this.scene = sc;
        FocusListener warning = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SettingsPanel.this.setMessage("settings.warning");
            }

            @Override
            public void focusLost(FocusEvent e) {
                SettingsPanel.this.setMessage(null);
            }
        };
        FocusListener restart = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SettingsPanel.this.setMessage("settings.restart");
            }

            @Override
            public void focusLost(FocusEvent e) {
                SettingsPanel.this.setMessage(null);
            }
        };
        this.minecraftTab = new TabbedEditorPanel.EditorPanelTab("settings.tab.minecraft");
        this.directory = new EditorFieldHandler("minecraft.gamedir", new EditorFileField("settings.client.gamedir.prompt", new FileExplorer(1, true)), warning);
        this.directory.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                if (!SettingsPanel.this.tlauncher.isReady()) {
                    return;
                }
                try {
                    SettingsPanel.this.tlauncher.getManager().getComponent(VersionLists.class).updateLocal();
                }
                catch (IOException e) {
                    Alert.showLocError("settings.client.gamedir.noaccess", e);
                    return;
                }
                SettingsPanel.this.tlauncher.getVersionManager().asyncRefresh();
                SettingsPanel.this.tlauncher.getProfileManager().recreate();
            }
        });
        this.minecraftTab.add(new EditorPair("settings.client.gamedir.label", this.directory));
        this.resolution = new EditorFieldHandler("minecraft.size", new EditorResolutionField("settings.client.resolution.width", "settings.client.resolution.height", this.global.getDefaultClientWindowSize(), false), restart);
        this.fullscreen = new EditorFieldHandler("minecraft.fullscreen", new EditorCheckBox("settings.client.resolution.fullscreen"));
        this.minecraftTab.add(new EditorPair("settings.client.resolution.label", this.resolution, this.fullscreen));
        this.minecraftTab.nextPane();
        List<ReleaseType> releaseTypes = ReleaseType.getDefinable();
        ArrayList<EditorFieldHandler> versions = new ArrayList<EditorFieldHandler>(releaseTypes.size());
        for (ReleaseType releaseType : ReleaseType.getDefinable()) {
            versions.add(new EditorFieldHandler("minecraft.versions." + (Object)((Object)releaseType), new EditorCheckBox("settings.versions." + (Object)((Object)releaseType))));
        }
        versions.add(new EditorFieldHandler("minecraft.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE), new EditorCheckBox("settings.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE))));
        this.versionHandler = new EditorGroupHandler(versions);
        this.versionHandler.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                TLauncher.getInstance().getVersionManager().updateVersionList();
            }
        });
        this.minecraftTab.add(new EditorPair("settings.versions.label", versions));
        this.minecraftTab.nextPane();
        this.javaArgs = new EditorFieldHandler("minecraft.javaargs", new EditorTextField("settings.java.args.jvm", true), warning);
        this.mcArgs = new EditorFieldHandler("minecraft.args", new EditorTextField("settings.java.args.minecraft", true), warning);
        this.minecraftTab.add(new EditorPair("settings.java.args.label", this.javaArgs, this.mcArgs));
        final boolean isWindows = OS.WINDOWS.isCurrent();
        this.javaPath = new EditorFieldHandler("minecraft.javadir", new EditorFileField("settings.java.path.prompt", true, new FileExplorer(isWindows ? 0 : 1, true)){

            @Override
            public boolean isValueValid() {
                if (this.checkPath()) {
                    return true;
                }
                Alert.showLocError("settings.java.path.doesnotexist");
                return false;
            }

            private boolean checkPath() {
                if (!isWindows) {
                    return true;
                }
                String path = this.getSettingsValue();
                if (path == null) {
                    return true;
                }
                if (!path.endsWith(".exe")) {
                    return false;
                }
                File javaDir = new File(path);
                return javaDir.isFile();
            }
        }, warning);
        this.minecraftTab.add(new EditorPair("settings.java.path.label", this.javaPath));
        this.minecraftTab.nextPane();
        this.memory = new EditorFieldHandler("minecraft.memory", new SettingsMemorySlider(), warning);
        this.minecraftTab.add(new EditorPair("settings.java.memory.label", this.memory));
        this.add(this.minecraftTab);
        this.tlauncherTab = new TabbedEditorPanel.EditorPanelTab("settings.tab.tlauncher");
        this.console = new EditorFieldHandler("gui.console", new EditorComboBox<Configuration.ConsoleType>(new ConsoleTypeConverter(), Configuration.ConsoleType.values()));
        this.console.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                if (newvalue == null) {
                    return;
                }
                switch (Configuration.ConsoleType.get(newvalue)) {
                    case GLOBAL: {
                        TLauncher.getConsole().show(false);
                        break;
                    }
                    case MINECRAFT: 
                    case NONE: {
                        TLauncher.getConsole().hide();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown console type!");
                    }
                }
            }
        });
        this.tlauncherTab.add(new EditorPair("settings.console.label", this.console));
        this.fullCommand = new EditorFieldHandler("gui.console.fullcommand", new EditorCheckBox("settings.console.fullcommand"));
        this.tlauncherTab.add(new EditorPair("settings.console.fullcommand.label", this.fullCommand));
        this.tlauncherTab.nextPane();
        this.connQuality = new EditorFieldHandler("connection", new EditorComboBox<Configuration.ConnectionQuality>(new ConnectionQualityConverter(), Configuration.ConnectionQuality.values()));
        this.connQuality.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldValue, String newValue) {
                SettingsPanel.this.tlauncher.getDownloader().setConfiguration(SettingsPanel.this.global.getConnectionQuality());
            }
        });
        this.tlauncherTab.add(new EditorPair("settings.connection.label", this.connQuality));
        this.launchAction = new EditorFieldHandler("minecraft.onlaunch", new EditorComboBox<Configuration.ActionOnLaunch>(new ActionOnLaunchConverter(), Configuration.ActionOnLaunch.values()));
        this.tlauncherTab.add(new EditorPair("settings.launch-action.label", this.launchAction));
        this.tlauncherTab.nextPane();
        this.locale = new EditorFieldHandler("locale", new EditorComboBox<Locale>(new LocaleConverter(), this.global.getLocales()));
        this.locale.addListener(new EditorFieldChangeListener(){

            @Override
            protected void onChange(String oldvalue, String newvalue) {
                if (SettingsPanel.this.tlauncher.getFrame() != null) {
                    SettingsPanel.this.tlauncher.getFrame().updateLocales();
                }
            }
        });
        this.tlauncherTab.add(new EditorPair("settings.lang.label", this.locale));
        this.add(this.tlauncherTab);
        this.saveButton = new LocalizableButton("settings.save");
        this.saveButton.setFont(this.saveButton.getFont().deriveFont(1));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.saveValues();
            }
        });
        this.defaultButton = new LocalizableButton("settings.default");
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Alert.showLocQuestion("settings.default.warning")) {
                    SettingsPanel.this.resetValues();
                }
            }
        });
        this.homeButton = new ImageButton("home.png");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPanel.this.updateValues();
                SettingsPanel.this.scene.setSidePanel(null);
            }
        });
        Dimension size = this.homeButton.getPreferredSize();
        if (size != null) {
            this.homeButton.setPreferredSize(new Dimension(size.width * 2, size.height));
        }
        this.buttonPanel = new BorderPanel();
        this.buttonPanel.setCenter(SettingsPanel.sepPan(this.saveButton, this.defaultButton));
        this.buttonPanel.setEast(SettingsPanel.uSepPan(this.homeButton));
        this.tabPane.addChangeListener(new ChangeListener(){
            private final String aboutBlock = "abouttab";

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SettingsPanel.this.tabPane.getSelectedComponent() instanceof TabbedEditorPanel.EditorScrollPane && !((TabbedEditorPanel.EditorScrollPane)SettingsPanel.this.tabPane.getSelectedComponent()).getTab().getSavingEnabled()) {
                    Blocker.blockComponents("abouttab", SettingsPanel.this.buttonPanel);
                } else {
                    Blocker.unblockComponents("abouttab", SettingsPanel.this.buttonPanel);
                }
            }
        });
        this.container.setSouth(this.buttonPanel);
        this.popup = new JPopupMenu();
        this.infoItem = new LocalizableMenuItem("settings.popup.info");
        this.infoItem.setEnabled(false);
        this.popup.add(this.infoItem);
        this.defaultItem = new LocalizableMenuItem("settings.popup.default");
        this.defaultItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPanel.this.selectedHandler == null) {
                    return;
                }
                SettingsPanel.this.resetValue(SettingsPanel.this.selectedHandler);
            }
        });
        this.popup.add(this.defaultItem);
        for (final EditorHandler handler : this.handlers) {
            JComponent handlerComponent = handler.getComponent();
            handlerComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() != 3) {
                        return;
                    }
                    SettingsPanel.this.callPopup(e, handler);
                }
            });
        }
        this.updateValues();
        this.updateLocale();
    }

    void updateValues() {
        boolean globalUnSaveable = !this.global.isSaveable();
        for (EditorHandler handler : this.handlers) {
            String path = handler.getPath();
            String value = this.global.get(path);
            handler.updateValue(value);
            this.setValid(handler, true);
            if (!globalUnSaveable && this.global.isSaveable(path)) continue;
            Blocker.block(handler, "unsaveable");
        }
    }

    public boolean saveValues() {
        if (!this.checkValues()) {
            return false;
        }
        for (EditorHandler handler : this.handlers) {
            String path = handler.getPath();
            String value = handler.getValue();
            this.global.set(path, value, false);
            handler.onChange(value);
        }
        this.global.store();
        return true;
    }

    void resetValues() {
        for (EditorHandler handler : this.handlers) {
            this.resetValue(handler);
        }
    }

    void resetValue(EditorHandler handler) {
        String path = handler.getPath();
        if (!this.global.isSaveable(path)) {
            return;
        }
        String value = this.global.getDefault(path);
        this.log("Resetting:", handler.getClass().getSimpleName(), path, value);
        handler.setValue(value);
        this.log("Reset!");
    }

    boolean canReset(EditorHandler handler) {
        String key = handler.getPath();
        return this.global.isSaveable(key) && this.global.getDefault(handler.getPath()) != null;
    }

    void callPopup(MouseEvent e, EditorHandler handler) {
        if (this.popup.isShowing()) {
            this.popup.setVisible(false);
        }
        this.defocus();
        int x = e.getX();
        int y = e.getY();
        this.selectedHandler = handler;
        this.updateResetMenu();
        this.infoItem.setVariables(handler.getPath());
        this.popup.show((JComponent)e.getSource(), x, y);
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(this.minecraftTab, reason);
        this.updateResetMenu();
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(this.minecraftTab, reason);
        this.updateResetMenu();
    }

    private void updateResetMenu() {
        if (this.selectedHandler != null) {
            this.defaultItem.setEnabled(!Blocker.isBlocked(this.selectedHandler));
        }
    }

    @Override
    public void logginingIn() throws LoginException {
        if (this.checkValues()) {
            return;
        }
        this.scene.setSidePanel(DefaultScene.SidePanel.SETTINGS);
        throw new LoginException("Invalid settings!");
    }

    @Override
    public void loginFailed() {
    }

    @Override
    public void loginSucceed() {
    }

    @Override
    public void updateLocale() {
    }
}

