/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.exceptions.ParseException;

public class StringUtil {
    private static String addQuotes(String a, char quote) {
        if (a == null) {
            return null;
        }
        if (a.length() == 0) {
            return "";
        }
        return String.valueOf(quote) + a.replaceAll("\\" + quote, "\\\\" + quote) + quote;
    }

    public static String addQuotes(String a) {
        return StringUtil.addQuotes(a, '\"');
    }

    public static String addSlashes(String str, EscapeGroup group) {
        if (str == null) {
            return "";
        }
        StringBuilder s = new StringBuilder(str);
        int i = 0;
        while (i < s.length()) {
            char curChar = s.charAt(i);
            char[] cArray = group.getChars();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (curChar == c) {
                    s.insert(i++, '\\');
                }
                ++n2;
            }
            ++i;
        }
        return s.toString();
    }

    public static String[] addSlashes(String[] str, EscapeGroup group) {
        if (str == null) {
            return null;
        }
        int len = str.length;
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = StringUtil.addSlashes(str[i], group);
            ++i;
        }
        return ret;
    }

    public static String iconv(String inChar, String outChar, String str) {
        Charset in = Charset.forName(inChar);
        Charset out = Charset.forName(outChar);
        CharsetDecoder decoder = in.newDecoder();
        CharsetEncoder encoder = out.newEncoder();
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(str));
            CharBuffer cbuf = decoder.decode(bbuf);
            return cbuf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean parseBoolean(String b) throws ParseException {
        if (b == null) {
            throw new ParseException("String cannot be NULL!");
        }
        if (b.equalsIgnoreCase("true")) {
            return true;
        }
        if (b.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParseException("Cannot parse value (" + b + ")!");
    }

    public static int countLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        int pos = 0;
        while (pos < len) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 < len && str.charAt(pos + 1) == '\n') {
                    ++pos;
                }
            } else if (c == '\n') {
                ++lines;
            }
            ++pos;
        }
        return lines;
    }

    public static char lastChar(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        int len = str.length();
        if (len == 0) {
            return '\u0000';
        }
        if (len == 1) {
            return str.charAt(0);
        }
        return str.charAt(len - 1);
    }

    public static String randomizeWord(String str, boolean softly) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len < 4) {
            return str;
        }
        boolean[] reversedFlag = new boolean[len];
        if (softly) {
            reversedFlag[0] = true;
        }
        boolean chosenLastLetter = !softly;
        char[] chars = str.toCharArray();
        int i = len - 1;
        while (i > -1) {
            char curChar = chars[i];
            int charType = Character.getType(curChar);
            boolean canBeReversed = charType == 1 || charType == 2;
            int n = i;
            reversedFlag[n] = reversedFlag[n] | !canBeReversed;
            if (canBeReversed && !chosenLastLetter) {
                reversedFlag[i] = true;
                chosenLastLetter = true;
            }
            --i;
        }
        i = 0;
        while (i < len) {
            if (!reversedFlag[i]) {
                int tries;
                int newPos = i;
                for (tries = 0; tries < 3; ++tries) {
                    newPos = new Random().nextInt(len);
                    if (reversedFlag[newPos]) continue;
                    tries = 10;
                    break;
                }
                if (tries == 10) {
                    char replaceChar;
                    char curChar = chars[i];
                    chars[i] = replaceChar = chars[newPos];
                    chars[newPos] = curChar;
                    reversedFlag[i] = true;
                    reversedFlag[newPos] = true;
                }
            }
            ++i;
        }
        return new String(chars);
    }

    public static String randomizeWord(String str) {
        return StringUtil.randomizeWord(str, true);
    }

    public static String randomize(String str, boolean softly) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return str;
        }
        String[] lines = str.split("\n");
        StringBuilder lineBuilder = new StringBuilder();
        boolean isFirstLine = true;
        int l = 0;
        while (l < lines.length) {
            String line = lines[l];
            String[] words = line.split(" ");
            StringBuilder wordBuilder = new StringBuilder();
            boolean isFirstWord = true;
            int w = 0;
            while (w < words.length) {
                if (isFirstWord) {
                    isFirstWord = false;
                } else {
                    wordBuilder.append(' ');
                }
                wordBuilder.append(StringUtil.randomizeWord(words[w]));
                ++w;
            }
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                lineBuilder.append('\n');
            }
            lineBuilder.append((CharSequence)wordBuilder);
            ++l;
        }
        return lineBuilder.toString();
    }

    public static String randomize(String str) {
        return StringUtil.randomize(str, true);
    }

    public static boolean isHTML(char[] s) {
        if (s != null && s.length >= 6 && s[0] == '<' && s[5] == '>') {
            String tag = new String(s, 1, 4);
            return tag.equalsIgnoreCase("html");
        }
        return false;
    }

    public static String wrap(char[] s, int maxChars, boolean rudeBreaking, boolean detectHTML) {
        if (s == null) {
            throw new NullPointerException("sequence");
        }
        if (maxChars < 1) {
            throw new IllegalArgumentException("maxChars < 1");
        }
        detectHTML = detectHTML && StringUtil.isHTML(s);
        String lineBreak = detectHTML ? "<br />" : "\n";
        StringBuilder builder = new StringBuilder();
        int len = s.length;
        int remaining = maxChars;
        boolean tagDetecting = false;
        boolean ignoreCurrent = false;
        int x = 0;
        while (x < len) {
            char current = s[x];
            if (current == '<' && detectHTML) {
                tagDetecting = true;
                ignoreCurrent = true;
            } else if (tagDetecting) {
                if (current == '>') {
                    tagDetecting = false;
                }
                ignoreCurrent = true;
            }
            if (ignoreCurrent) {
                ignoreCurrent = false;
                builder.append(current);
            } else if (s[x] == '\n' || --remaining < 1 && current == ' ') {
                remaining = maxChars;
                builder.append(lineBreak);
            } else {
                if (StringUtil.lookForward(s, x, lineBreak)) {
                    remaining = maxChars;
                }
                builder.append(current);
                if (remaining <= 0 && rudeBreaking) {
                    remaining = maxChars;
                    builder.append(lineBreak);
                }
            }
            ++x;
        }
        return builder.toString();
    }

    private static boolean lookForward(char[] c, int caret, CharSequence search) {
        int available;
        if (c == null) {
            throw new NullPointerException("char array");
        }
        if (caret < 0) {
            throw new IllegalArgumentException("caret < 0");
        }
        if (caret >= c.length) {
            return false;
        }
        int length = search.length();
        if (length < (available = c.length - caret)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (c[caret + i] != search.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String wrap(String s, int maxChars, boolean rudeBreaking, boolean detectHTML) {
        return StringUtil.wrap(s.toCharArray(), maxChars, rudeBreaking, detectHTML);
    }

    public static String wrap(char[] s, int maxChars, boolean rudeBreaking) {
        return StringUtil.wrap(s, maxChars, rudeBreaking, true);
    }

    public static String wrap(char[] s, int maxChars) {
        return StringUtil.wrap(s, maxChars, false);
    }

    public static String wrap(String s, int maxChars) {
        return StringUtil.wrap(s.toCharArray(), maxChars);
    }

    public static String cut(String string, int max) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len <= max) {
            return string;
        }
        String[] words = string.split(" ");
        String ret = "";
        int remaining = max + 1;
        int x = 0;
        while (x < words.length) {
            String curword = words[x];
            int curlen = curword.length();
            if (curlen < remaining) {
                ret = String.valueOf(ret) + " " + curword;
                remaining -= curlen + 1;
            } else {
                if (x != 0) break;
                ret = String.valueOf(ret) + " " + curword.substring(0, remaining - 1);
                break;
            }
            ++x;
        }
        if (ret.length() == 0) {
            return "";
        }
        return String.valueOf(ret.substring(1)) + "...";
    }

    public static String requireNotBlank(String s, String name) {
        if (s == null) {
            throw new NullPointerException(name);
        }
        if (StringUtils.isBlank(s)) {
            throw new IllegalArgumentException(name);
        }
        return s;
    }

    public static enum EscapeGroup {
        DOUBLE_QUOTE('\"'),
        COMMAND(DOUBLE_QUOTE, '\'', ' '),
        REGEXP(COMMAND, '/', '\\', '?', '*', '+', '[', ']', ':', '{', '}', '(', ')');

        private final char[] chars;

        private EscapeGroup(char ... symbols) {
            this.chars = symbols;
        }

        private EscapeGroup(EscapeGroup extend, char ... symbols) {
            int len = extend.chars.length + symbols.length;
            this.chars = new char[len];
            int x = 0;
            while (x < extend.chars.length) {
                this.chars[x] = extend.chars[x];
                ++x;
            }
            System.arraycopy(symbols, 0, this.chars, x, symbols.length);
        }

        public char[] getChars() {
            return this.chars;
        }
    }
}

