/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.util.U;

public class SwingUtil {
    private static final List<Image> favicons = new ArrayList<Image>();

    public static List<Image> getFavicons() {
        if (!favicons.isEmpty()) {
            return Collections.unmodifiableList(favicons);
        }
        int[] sizes = new int[]{256, 128, 96, 64, 48, 32, 24, 16};
        String loaded = "";
        int[] nArray = sizes;
        int n = sizes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            BufferedImage image = ImageCache.getImage("fav" + i + ".png", false);
            if (image != null) {
                loaded = String.valueOf(loaded) + ", " + i + "px";
                favicons.add(image);
            }
            ++n2;
        }
        if (loaded.isEmpty()) {
            SwingUtil.log("No favicon is loaded.");
        } else {
            SwingUtil.log("Favicons loaded:", loaded.substring(2));
        }
        return favicons;
    }

    public static void setFavicons(JFrame frame) {
        frame.setIconImages(SwingUtil.getFavicons());
    }

    public static void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            SwingUtil.log("Can't set system look and feel.");
            e.printStackTrace();
        }
    }

    public static void initFontSize(int defSize) {
        try {
            UIDefaults defaults = UIManager.getDefaults();
            int minSize = defSize;
            int maxSize = defSize + 2;
            Enumeration e = defaults.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = defaults.get(key);
                if (!(value instanceof Font)) continue;
                Font font = (Font)value;
                int size = font.getSize();
                if (size < minSize) {
                    size = minSize;
                } else if (size > maxSize) {
                    size = maxSize;
                }
                if (value instanceof FontUIResource) {
                    defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), size));
                    continue;
                }
                defaults.put(key, new Font(font.getName(), font.getStyle(), size));
            }
        }
        catch (Exception e) {
            SwingUtil.log("Cannot change font sizes!", e);
        }
    }

    public static Cursor getCursor(int type) {
        try {
            return Cursor.getPredefinedCursor(type);
        }
        catch (IllegalArgumentException iaE) {
            iaE.printStackTrace();
            return null;
        }
    }

    public static void setFontSize(JComponent comp, float size) {
        comp.setFont(comp.getFont().deriveFont(size));
    }

    public static Point getRelativeLocation(Component parent, Component comp) {
        Point compLocation = comp.getLocationOnScreen();
        Point parentLocation = parent.getLocationOnScreen();
        return new Point(compLocation.x - parentLocation.x, compLocation.y - parentLocation.y);
    }

    private static void log(Object ... o) {
        U.log("[Swing]", o);
    }
}

