/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Library;
import net.minecraft.launcher.versions.Version;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;

public class VersionSyncInfo {
    protected Version localVersion;
    protected Version remoteVersion;
    private CompleteVersion completeLocal;
    private CompleteVersion completeRemote;
    private String id;

    public VersionSyncInfo(Version localVersion, Version remoteVersion) {
        if (localVersion == null && remoteVersion == null) {
            throw new NullPointerException("Cannot create sync info from NULLs!");
        }
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
        if (localVersion != null && remoteVersion != null) {
            localVersion.setVersionList(remoteVersion.getVersionList());
        }
        if (this.getID() == null) {
            throw new NullPointerException("Cannot create sync info from versions that have NULL IDs");
        }
    }

    public VersionSyncInfo(VersionSyncInfo info) {
        this(info.getLocal(), info.getRemote());
    }

    private VersionSyncInfo() {
        this.localVersion = null;
        this.remoteVersion = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getID() == null || o == null || !(o instanceof VersionSyncInfo)) {
            return false;
        }
        VersionSyncInfo v = (VersionSyncInfo)o;
        return this.getID().equals(v.getID());
    }

    public Version getLocal() {
        return this.localVersion;
    }

    public void setLocal(Version version) {
        this.localVersion = version;
        if (version instanceof CompleteVersion) {
            this.completeLocal = (CompleteVersion)version;
        }
    }

    public Version getRemote() {
        return this.remoteVersion;
    }

    public void setRemote(Version version) {
        this.remoteVersion = version;
        if (version instanceof CompleteVersion) {
            this.completeRemote = (CompleteVersion)version;
        }
    }

    public String getID() {
        if (this.id != null) {
            return this.id;
        }
        if (this.localVersion != null) {
            return this.localVersion.getID();
        }
        if (this.remoteVersion != null) {
            return this.remoteVersion.getID();
        }
        return null;
    }

    public void setID(String id) {
        if (id != null && id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be empty!");
        }
        this.id = id;
    }

    public Version getLatestVersion() {
        if (this.remoteVersion != null) {
            return this.remoteVersion;
        }
        return this.localVersion;
    }

    public Version getAvailableVersion() {
        if (this.localVersion != null) {
            return this.localVersion;
        }
        return this.remoteVersion;
    }

    public boolean isInstalled() {
        return this.localVersion != null;
    }

    public boolean hasRemote() {
        return this.remoteVersion != null;
    }

    public boolean isUpToDate() {
        if (this.localVersion == null) {
            return false;
        }
        if (this.remoteVersion == null) {
            return true;
        }
        return this.localVersion.getUpdatedTime().compareTo(this.remoteVersion.getUpdatedTime()) >= 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{id='" + this.getID() + "',\nlocal=" + this.localVersion + ",\nremote=" + this.remoteVersion + ", isInstalled=" + this.isInstalled() + ", hasRemote=" + this.hasRemote() + ", isUpToDate=" + this.isUpToDate() + "}";
    }

    public CompleteVersion resolveCompleteVersion(VersionManager manager, boolean latest) throws IOException {
        Version version = latest ? this.getLatestVersion() : (this.isInstalled() ? this.getLocal() : this.getRemote());
        if (version.equals(this.localVersion) && this.completeLocal != null && this.completeLocal.getInheritsFrom() == null) {
            return this.completeLocal;
        }
        if (version.equals(this.remoteVersion) && this.completeRemote != null && this.completeRemote.getInheritsFrom() == null) {
            return this.completeRemote;
        }
        CompleteVersion complete = version.getVersionList().getCompleteVersion(version).resolve(manager, latest);
        if (version == this.localVersion) {
            this.completeLocal = complete;
        } else if (version == this.remoteVersion) {
            this.completeRemote = complete;
        }
        return complete;
    }

    public CompleteVersion getCompleteVersion(boolean latest) throws IOException {
        Version version = latest ? this.getLatestVersion() : (this.isInstalled() ? this.getLocal() : this.getRemote());
        if (version.equals(this.localVersion) && this.completeLocal != null) {
            return this.completeLocal;
        }
        if (version.equals(this.remoteVersion) && this.completeRemote != null) {
            return this.completeRemote;
        }
        CompleteVersion complete = version.getVersionList().getCompleteVersion(version);
        if (version == this.localVersion) {
            this.completeLocal = complete;
        } else if (version == this.remoteVersion) {
            this.completeRemote = complete;
        }
        return complete;
    }

    public CompleteVersion getLatestCompleteVersion() throws IOException {
        return this.getCompleteVersion(true);
    }

    public CompleteVersion getLocalCompleteVersion() {
        return this.completeLocal;
    }

    Set<Downloadable> getRequiredDownloadables(OS os, File targetDirectory, boolean force, boolean ely) throws IOException {
        Repository source;
        HashSet<Downloadable> neededFiles = new HashSet<Downloadable>();
        CompleteVersion version = this.getCompleteVersion(force);
        if (ely) {
            version = TLauncher.getInstance().getElyManager().elyficate(version);
        }
        Repository repository = source = this.hasRemote() ? this.remoteVersion.getSource() : Repository.OFFICIAL_VERSION_REPO;
        if (!source.isSelectable()) {
            return neededFiles;
        }
        for (Library library : version.getRelevantLibraries()) {
            String file = null;
            if (library.getNatives() != null) {
                String natives = library.getNatives().get((Object)os);
                if (natives != null) {
                    file = library.getArtifactPath(natives);
                }
            } else {
                file = library.getArtifactPath();
            }
            if (file == null) continue;
            File local = new File(targetDirectory, "libraries/" + file);
            if (!force && local.isFile() && (library.getChecksum() == null || library.getChecksum().equals(FileUtil.getChecksum(local, "SHA-1")))) continue;
            neededFiles.add(library.getDownloadable(source, local, os));
        }
        return neededFiles;
    }

    public Set<Downloadable> getRequiredDownloadables(File targetDirectory, boolean force, boolean ely) throws IOException {
        return this.getRequiredDownloadables(OS.CURRENT, targetDirectory, force, ely);
    }

    public static VersionSyncInfo createEmpty() {
        return new VersionSyncInfo();
    }
}

