/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.util.UUID;
import ru.turikhay.exceptions.ParseException;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.util.IntegerArray;
import ru.turikhay.util.StringUtil;

class PlainParser {
    PlainParser() {
    }

    public static void parse(Object plainValue, Object defaultValue) throws ParseException {
        if (defaultValue == null) {
            return;
        }
        if (plainValue == null) {
            throw new ParseException("Value is NULL");
        }
        String value = plainValue.toString();
        try {
            if (defaultValue instanceof Integer) {
                Integer.parseInt(value);
            } else if (defaultValue instanceof Boolean) {
                StringUtil.parseBoolean(value);
            } else if (defaultValue instanceof Double) {
                Double.parseDouble(value);
            } else if (defaultValue instanceof Long) {
                Long.parseLong(value);
            } else if (defaultValue instanceof IntegerArray) {
                IntegerArray.parseIntegerArray(value);
            } else if (defaultValue instanceof Configuration.ActionOnLaunch) {
                if (!Configuration.ActionOnLaunch.parse(value)) {
                    throw new ParseException("Cannot parse ActionOnLaunch");
                }
            } else if (defaultValue instanceof Configuration.ConsoleType) {
                if (!Configuration.ConsoleType.parse(value)) {
                    throw new ParseException("Cannot parse ConsoleType");
                }
            } else if (defaultValue instanceof Configuration.ConnectionQuality) {
                if (!Configuration.ConnectionQuality.parse(value)) {
                    throw new ParseException("Cannot parse ConnectionQuality");
                }
            } else if (defaultValue instanceof UUID) {
                UUID.fromString(value);
            }
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)e;
            }
            throw new ParseException("Cannot parse input value!", e);
        }
    }
}

