/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.downloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.DownloadableContainerHandler;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.ui.console.Console;

public class DownloadableContainer {
    private final List<DownloadableContainerHandler> handlers;
    private final List<Throwable> errors;
    final List<Downloadable> list = Collections.synchronizedList(new ArrayList());
    private Console console;
    private final AtomicInteger sum;
    private boolean locked;
    private boolean aborted;

    public DownloadableContainer() {
        this.handlers = Collections.synchronizedList(new ArrayList());
        this.errors = Collections.synchronizedList(new ArrayList());
        this.sum = new AtomicInteger();
    }

    public List<Downloadable> getList() {
        return Collections.unmodifiableList(this.list);
    }

    public void add(Downloadable d) {
        if (d == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        if (this.list.contains(d)) {
            return;
        }
        this.list.add(d);
        d.setContainer(this);
        this.sum.incrementAndGet();
    }

    public void addAll(Downloadable ... ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < ds.length) {
            if (ds[i] == null) {
                throw new NullPointerException("Downloadable at " + i + " is NULL!");
            }
            if (!this.list.contains(ds[i])) {
                this.list.add(ds[i]);
                ds[i].setContainer(this);
                this.sum.incrementAndGet();
            }
            ++i;
        }
    }

    public void addAll(Collection<Downloadable> coll) {
        if (coll == null) {
            throw new NullPointerException();
        }
        int i = -1;
        for (Downloadable d : coll) {
            ++i;
            if (d == null) {
                throw new NullPointerException("Downloadable at" + i + " is NULL!");
            }
            this.list.add(d);
            d.setContainer(this);
            this.sum.incrementAndGet();
        }
    }

    public void addHandler(DownloadableContainerHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.checkLocked();
        this.handlers.add(handler);
    }

    public List<Throwable> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public Console getConsole() {
        return this.console;
    }

    public boolean hasConsole() {
        return this.console != null;
    }

    public void setConsole(Console console) {
        this.checkLocked();
        this.console = console;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    void setLocked(boolean locked) {
        this.locked = locked;
    }

    void checkLocked() {
        if (this.locked) {
            throw new IllegalStateException("Downloadable is locked!");
        }
    }

    void onStart() {
        for (DownloadableContainerHandler handler : this.handlers) {
            handler.onStart(this);
        }
    }

    void onComplete(Downloadable d) throws RetryDownloadException {
        for (DownloadableContainerHandler handler : this.handlers) {
            handler.onComplete(this, d);
        }
        if (this.sum.decrementAndGet() > 0) {
            return;
        }
        for (DownloadableContainerHandler handler : this.handlers) {
            handler.onFullComplete(this);
        }
    }

    void onAbort(Downloadable d) {
        this.aborted = true;
        this.errors.add(d.getError());
        if (this.sum.decrementAndGet() > 0) {
            return;
        }
        for (DownloadableContainerHandler handler : this.handlers) {
            handler.onAbort(this);
        }
    }

    void onError(Downloadable d, Throwable e) {
        this.errors.add(e);
        for (DownloadableContainerHandler handler : this.handlers) {
            handler.onError(this, d, e);
        }
    }

    void log(Object ... o) {
        if (this.console == null) {
            return;
        }
        this.console.log(o);
    }

    public static void removeDuplicates(DownloadableContainer a, DownloadableContainer b) {
        if (a.locked) {
            throw new IllegalStateException("First conatiner is already locked!");
        }
        if (b.locked) {
            throw new IllegalStateException("Second container is already locked!");
        }
        a.locked = true;
        b.locked = true;
        try {
            List<Downloadable> aList = a.list;
            List<Downloadable> bList = b.list;
            ArrayList<Downloadable> deleteList = new ArrayList<Downloadable>();
            for (Downloadable aDownloadable : aList) {
                for (Downloadable bDownloadable : bList) {
                    if (!aDownloadable.equals(bDownloadable)) continue;
                    deleteList.add(bDownloadable);
                }
            }
            bList.removeAll(deleteList);
        }
        finally {
            a.locked = false;
            b.locked = false;
        }
    }

    public static void removeDuplicates(List<? extends DownloadableContainer> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.size() < 2) {
            return;
        }
        int i = 0;
        while (i < list.size() - 1) {
            int k = i + 1;
            while (k < list.size()) {
                DownloadableContainer.removeDuplicates(list.get(i), list.get(k));
                ++k;
            }
            ++i;
        }
    }
}

