/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.minecraft.auth;

import java.util.UUID;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorException;
import ru.turikhay.tlauncher.minecraft.auth.AuthenticatorListener;
import ru.turikhay.tlauncher.minecraft.auth.ElyAuthenticator;
import ru.turikhay.tlauncher.minecraft.auth.MojangAuthenticator;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public abstract class Authenticator {
    protected final Account account;
    private final String logPrefix = String.valueOf('[') + this.getClass().getSimpleName() + ']';

    protected Authenticator(Account account) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        this.account = account;
    }

    public final Account getAccount() {
        return this.account;
    }

    public boolean pass(AuthenticatorListener l) {
        if (l != null) {
            l.onAuthPassing(this);
        }
        try {
            this.pass();
        }
        catch (Exception e) {
            this.log("Cannot authenticate:", e);
            if (l != null) {
                l.onAuthPassingError(this, e);
            }
            return false;
        }
        if (l != null) {
            l.onAuthPassed(this);
        }
        return true;
    }

    public void asyncPass(final AuthenticatorListener l) {
        AsyncThread.execute(new Runnable(){

            @Override
            public void run() {
                Authenticator.this.pass(l);
            }
        });
    }

    protected abstract void pass() throws AuthenticatorException;

    protected void log(Object ... o) {
        U.log(this.logPrefix, o);
    }

    public static Authenticator instanceFor(Account account) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        U.log("instancefor:", account);
        switch (account.getType()) {
            case ELY: {
                return new ElyAuthenticator(account);
            }
            case MOJANG: {
                return new MojangAuthenticator(account);
            }
        }
        throw new IllegalArgumentException("illegal account type");
    }

    protected static UUID getClientToken() {
        return TLauncher.getInstance().getProfileManager().getClientToken();
    }

    protected static void setClientToken(String uuid) {
        TLauncher.getInstance().getProfileManager().setClientToken(uuid);
    }
}

