/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.browser;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.browser.BrowserHolder;
import ru.turikhay.tlauncher.ui.images.ImageCache;

public class BrowserFallback
extends JPanel
implements Blockable {
    private final BrowserHolder holder;
    private Image image;
    private int imageWidth;
    private int imageHeight;

    BrowserFallback(BrowserHolder holder) {
        this.holder = holder;
    }

    private void updateImage() {
        this.image = ImageCache.getImage("plains.jpg");
        this.imageWidth = this.image.getWidth(null);
        this.imageHeight = this.image.getHeight(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        double height;
        double width;
        double windowHeight;
        if (this.image == null) {
            return;
        }
        double windowWidth = this.getWidth();
        double ratio = Math.min((double)this.imageWidth / windowWidth, (double)this.imageHeight / (windowHeight = (double)this.getHeight()));
        if (ratio < 1.0) {
            width = this.imageWidth;
            height = this.imageHeight;
        } else {
            width = (double)this.imageWidth / ratio;
            height = (double)this.imageHeight / ratio;
        }
        double x = (windowWidth - width) / 2.0;
        double y = (windowHeight - height) / 2.0;
        g.drawImage(this.image, (int)x, (int)y, (int)width, (int)height, null);
    }

    @Override
    public void block(Object reason) {
        this.holder.removeAll();
        this.holder.setCenter((Component)((Object)this.holder.browser));
    }

    @Override
    public void unblock(Object reason) {
        this.updateImage();
        this.holder.removeAll();
        this.holder.setCenter(this);
        if (this.holder.browser != null) {
            this.holder.browser.cleanupResources();
        }
    }
}

