/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import java.io.File;
import java.net.URI;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashSignatureContainer;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class MinecraftUIListener
implements MinecraftListener {
    private final TLauncher t;
    private final LangConfiguration lang;

    public MinecraftUIListener(TLauncher tlauncher) {
        this.t = tlauncher;
        this.lang = this.t.getLang();
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
        if (!this.t.getSettings().getActionOnLaunch().equals((Object)Configuration.ActionOnLaunch.NOTHING)) {
            this.t.hide();
        }
    }

    @Override
    public void onMinecraftClose() {
        if (!this.t.getLauncher().isLaunchAssist()) {
            return;
        }
        this.t.show();
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        if (!this.t.getLauncher().isLaunchAssist()) {
            this.t.show();
        }
        String p = "crash.";
        String title = Localizable.get(String.valueOf(p) + "title");
        String report = crash.getFile();
        if (!crash.isRecognized()) {
            Alert.showLocError(title, String.valueOf(p) + "unknown", null);
        } else {
            for (CrashSignatureContainer.CrashSignature sign : crash.getSignatures()) {
                String path = sign.getPath();
                String message = String.valueOf(p) + path;
                String url = String.valueOf(message) + ".url";
                URI uri = U.makeURI(url);
                if (uri != null) {
                    if (!Alert.showLocQuestion(title, message, report)) continue;
                    OS.openLink(uri);
                    continue;
                }
                Alert.showLocMessage(title, message, report);
            }
        }
        if (report == null) {
            return;
        }
        if (Alert.showLocQuestion(String.valueOf(p) + "store")) {
            U.log("Removing crash report...");
            File file = new File(report);
            if (!file.exists()) {
                U.log("File is already removed. LOL.");
            } else {
                if (!file.delete()) {
                    U.log("Can't delete crash report file. Okay.");
                    Alert.showLocMessage(String.valueOf(p) + "store.failed");
                    return;
                }
                U.log("Yay, crash report file doesn't exist by now.");
            }
            Alert.showLocMessage(String.valueOf(p) + "store.success");
        }
    }

    @Override
    public void onMinecraftError(Throwable e) {
        Alert.showLocError("launcher.error.title", "launcher.error.unknown", e);
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Alert.showError(this.lang.get("launcher.error.title"), this.lang.get("launcher.error." + e.getLangPath(), e.getLangVars()), e.getCause());
    }
}

