/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.loc;

import java.awt.Component;
import java.awt.Container;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.U;

public class Localizable {
    public static final Object[] EMPTY_VARS = new Object[0];
    public static final LocalizableFilter defaultFilter = new LocalizableFilter(){

        @Override
        public boolean localize(Component comp) {
            return true;
        }
    };
    private static LangConfiguration lang;

    public static void setLang(LangConfiguration l) {
        lang = l;
    }

    public static LangConfiguration get() {
        return lang;
    }

    public static boolean exists() {
        return lang != null;
    }

    public static String get(String path) {
        return lang != null ? lang.get(path) : path;
    }

    public static String get(String path, Object ... vars) {
        return lang != null ? lang.get(path, vars) : String.valueOf(path) + " {" + U.toLog(vars) + "}";
    }

    public static String nget(String path) {
        return lang != null ? lang.nget(path) : null;
    }

    public static String[] checkVariables(Object[] check) {
        if (check == null) {
            throw new NullPointerException();
        }
        String[] string = new String[check.length];
        int i = 0;
        while (i < check.length) {
            if (check[i] == null) {
                throw new NullPointerException("Variable at index " + i + " is NULL!");
            }
            string[i] = check[i].toString();
            ++i;
        }
        return string;
    }

    public static void updateContainer(Container container, LocalizableFilter filter) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            LocalizableComponent asLocalizable = Reflect.cast(c, LocalizableComponent.class);
            if (asLocalizable != null && filter.localize(c)) {
                asLocalizable.updateLocale();
            }
            if (c instanceof Container) {
                Localizable.updateContainer((Container)c, filter);
            }
            ++n2;
        }
    }

    public static void updateContainer(Container container) {
        Localizable.updateContainer(container, defaultFilter);
    }

    public static interface LocalizableFilter {
        public boolean localize(Component var1);
    }
}

