/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.loc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;

public class LocalizableMenuItem
extends JMenuItem
implements LocalizableComponent {
    private static final long serialVersionUID = 1364363532569997394L;
    private static List<LocalizableMenuItem> items = Collections.synchronizedList(new ArrayList());
    private String path;
    private String[] variables;

    public LocalizableMenuItem(String path, Object ... vars) {
        items.add(this);
        this.setText(path, vars);
    }

    public LocalizableMenuItem(String path) {
        this(path, Localizable.EMPTY_VARS);
    }

    public void setText(String path, Object ... vars) {
        this.path = path;
        this.variables = Localizable.checkVariables(vars);
        String value = Localizable.get(path);
        int i = 0;
        while (i < this.variables.length) {
            value = value.replace("%" + i, this.variables[i]);
            ++i;
        }
        super.setText(value);
    }

    @Override
    public void setText(String path) {
        this.setText(path, Localizable.EMPTY_VARS);
    }

    public void setVariables(Object ... vars) {
        this.setText(this.path, vars);
    }

    @Override
    public void updateLocale() {
        this.setText(this.path, this.variables);
    }

    public static void updateLocales() {
        for (LocalizableMenuItem item : items) {
            if (item == null) continue;
            item.updateLocale();
        }
    }
}

