/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.text;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.center.CenterPanelTheme;

public class ExtendedPasswordField
extends JPasswordField {
    private static final long serialVersionUID = 3175896797135831502L;
    private static final String DEFAULT_PLACEHOLDER = "\u043f\u0430\u0441\u0441\u0432\u043e\u0440\u0434, \u043b\u043e\u043b";
    private CenterPanelTheme theme;
    private String placeholder;

    private ExtendedPasswordField(CenterPanel panel, String placeholder) {
        this.theme = panel == null ? CenterPanel.defaultTheme : panel.getTheme();
        this.placeholder = placeholder == null ? DEFAULT_PLACEHOLDER : placeholder;
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ExtendedPasswordField.this.onFocusGained();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ExtendedPasswordField.this.onFocusLost();
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtendedPasswordField.this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtendedPasswordField.this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExtendedPasswordField.this.onChange();
            }
        });
        this.setText(null);
    }

    public ExtendedPasswordField() {
        this(null, null);
    }

    private String getValueOf(String value) {
        if (value == null || value.isEmpty() || value.equals(this.placeholder)) {
            return null;
        }
        return value;
    }

    @Override
    @Deprecated
    public String getText() {
        return super.getText();
    }

    @Override
    public char[] getPassword() {
        String value = this.getValue();
        if (value == null) {
            return new char[0];
        }
        return value.toCharArray();
    }

    public boolean hasPassword() {
        return this.getValue() != null;
    }

    private String getValue() {
        return this.getValueOf(this.getText());
    }

    @Override
    public void setText(String text) {
        String value = this.getValueOf(text);
        if (value == null) {
            this.setPlaceholder();
        } else {
            this.setForeground(this.theme.getFocus());
            super.setText(value);
        }
    }

    private void setPlaceholder() {
        this.setForeground(this.theme.getFocusLost());
        super.setText(this.placeholder);
    }

    private void setEmpty() {
        this.setForeground(this.theme.getFocus());
        super.setText("");
    }

    void updateStyle() {
        this.setForeground(this.getValue() == null ? this.theme.getFocusLost() : this.theme.getFocus());
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        String string = this.placeholder = placeholder == null ? DEFAULT_PLACEHOLDER : placeholder;
        if (this.getValue() == null) {
            this.setPlaceholder();
        }
    }

    public CenterPanelTheme getTheme() {
        return this.theme;
    }

    public void setTheme(CenterPanelTheme theme) {
        if (theme == null) {
            theme = CenterPanel.defaultTheme;
        }
        this.theme = theme;
        this.updateStyle();
    }

    protected void onFocusGained() {
        if (this.getValue() == null) {
            this.setEmpty();
        }
    }

    protected void onFocusLost() {
        if (this.getValue() == null) {
            this.setPlaceholder();
        }
    }

    protected void onChange() {
    }
}

