/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.updater;

import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.AutoUpdaterFrame;
import ru.turikhay.tlauncher.updater.Update;
import ru.turikhay.tlauncher.updater.UpdateListener;
import ru.turikhay.tlauncher.updater.Updater;
import ru.turikhay.tlauncher.updater.UpdaterListener;

public class AutoUpdater
extends Updater {
    private final TLauncher t;
    private final AutoUpdaterFrame frame;
    private final UpdaterListener updaterL;
    private final UpdateListener updateL;

    public AutoUpdater(TLauncher tlauncher) {
        this.t = tlauncher;
        this.frame = new AutoUpdaterFrame(this);
        this.addListener(this.frame);
        this.updaterL = new UpdaterListener(){

            @Override
            public void onUpdaterRequesting(Updater u) {
            }

            @Override
            public void onUpdaterErrored(Updater.SearchFailed failed) {
            }

            @Override
            public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
                if (AutoUpdater.this.isClosed()) {
                    return;
                }
                Update upd = succeeded.getResponse().getUpdate();
                if (upd.isApplicable()) {
                    upd.addListener(AutoUpdater.this.updateL);
                    upd.download();
                }
            }
        };
        this.updateL = new UpdateListener(){

            @Override
            public void onUpdateError(Update u, Throwable e) {
            }

            @Override
            public void onUpdateDownloading(Update u) {
            }

            @Override
            public void onUpdateDownloadError(Update u, Throwable e) {
            }

            @Override
            public void onUpdateReady(Update u) {
                if (!AutoUpdater.this.isClosed()) {
                    u.apply();
                }
            }

            @Override
            public void onUpdateApplying(Update u) {
            }

            @Override
            public void onUpdateApplyError(Update u, Throwable e) {
                System.exit(0);
            }
        };
        this.addListener(this.updaterL);
    }

    public TLauncher getLauncher() {
        return this.t;
    }

    @Override
    protected Updater.SearchResult findUpdate0() {
        this.frame.openFrame();
        return super.findUpdate0();
    }

    public void cancelUpdate() {
        this.t.getDownloader().stopDownload();
    }

    public boolean isClosed() {
        return this.frame.isClosed();
    }
}

