/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.io.File;
import java.io.IOException;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class MinecraftUtil {
    public static File getWorkingDirectory() {
        if (TLauncher.getInstance() == null) {
            return MinecraftUtil.getDefaultWorkingDirectory();
        }
        Configuration settings = TLauncher.getInstance().getSettings();
        String sdir = settings.get("minecraft.gamedir");
        if (sdir == null) {
            return MinecraftUtil.getDefaultWorkingDirectory();
        }
        File dir = new File(sdir);
        try {
            FileUtil.createFolder(dir);
        }
        catch (IOException e) {
            U.log("Cannot create specified Minecraft folder:", dir.getAbsolutePath());
            return MinecraftUtil.getDefaultWorkingDirectory();
        }
        return dir;
    }

    public static File getSystemRelatedFile(String path) {
        File file;
        String userHome = System.getProperty("user.home", ".");
        switch (OS.CURRENT) {
            case LINUX: 
            case SOLARIS: {
                file = new File(userHome, path);
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                String folder = applicationData != null ? applicationData : userHome;
                file = new File(folder, path);
                break;
            }
            case OSX: {
                file = new File(userHome, "Library/Application Support/" + path);
                break;
            }
            default: {
                file = new File(userHome, path);
            }
        }
        return file;
    }

    public static File getSystemRelatedDirectory(String path) {
        if (!OS.is(OS.OSX, OS.UNKNOWN)) {
            path = String.valueOf('.') + path;
        }
        return MinecraftUtil.getSystemRelatedFile(path);
    }

    public static File getDefaultWorkingDirectory() {
        return MinecraftUtil.getSystemRelatedDirectory(TLauncher.getFolder());
    }

    public static File getOptionsFile() {
        return MinecraftUtil.getFile("options.txt");
    }

    private static File getFile(String name) {
        return new File(MinecraftUtil.getWorkingDirectory(), name);
    }
}

