/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Desktop;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.util.U;

public enum OS {
    LINUX("linux", "unix"),
    WINDOWS("win"),
    OSX("mac"),
    SOLARIS("solaris", "sunos"),
    UNKNOWN("unknown");

    public static final String NAME;
    public static final String VERSION;
    public static final double JAVA_VERSION;
    public static final OS CURRENT;
    private final String name;
    private final String[] aliases;

    static {
        NAME = System.getProperty("os.name");
        VERSION = System.getProperty("os.version");
        JAVA_VERSION = OS.getJavaVersion();
        CURRENT = OS.getCurrent();
    }

    private OS(String ... aliases) {
        if (aliases == null) {
            throw new NullPointerException();
        }
        this.name = this.toString().toLowerCase();
        this.aliases = aliases;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnsupported() {
        return this == UNKNOWN;
    }

    public boolean isCurrent() {
        return this == CURRENT;
    }

    private static OS getCurrent() {
        String osName = NAME.toLowerCase();
        OS[] oSArray = OS.values();
        int n = oSArray.length;
        int n2 = 0;
        while (n2 < n) {
            OS os = oSArray[n2];
            String[] stringArray = os.aliases;
            int n3 = os.aliases.length;
            int n4 = 0;
            while (n4 < n3) {
                String alias = stringArray[n4];
                if (osName.contains(alias)) {
                    return os;
                }
                ++n4;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private static double getJavaVersion() {
        String version = System.getProperty("java.version");
        int count = 0;
        int pos = 0;
        while (pos < version.length() && count < 2) {
            if (version.charAt(pos) == '.') {
                ++count;
            }
            ++pos;
        }
        String doubleVersion = version.substring(0, --pos);
        return Double.parseDouble(doubleVersion);
    }

    public static boolean is(OS ... any) {
        if (any == null) {
            throw new NullPointerException();
        }
        if (any.length == 0) {
            return false;
        }
        OS[] oSArray = any;
        int n = any.length;
        int n2 = 0;
        while (n2 < n) {
            OS compare = oSArray[n2];
            if (CURRENT == compare) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getJavaPath(boolean appendBinFolder) {
        char separator = File.separatorChar;
        String path = String.valueOf(System.getProperty("java.home")) + separator;
        if (appendBinFolder) {
            path = String.valueOf(path) + "bin" + separator + "java";
            if (CURRENT == WINDOWS) {
                path = String.valueOf(path) + "w.exe";
            }
        }
        return path;
    }

    public static String getJavaPath() {
        return OS.getJavaPath(true);
    }

    public static String getSummary() {
        return String.valueOf(NAME) + " " + VERSION + " " + (Object)((Object)Arch.CURRENT) + ", Java " + System.getProperty("java.version") + ", " + Arch.TOTAL_RAM_MB + " MB RAM";
    }

    private static void rawOpenLink(URI uri) throws Throwable {
        Desktop.getDesktop().browse(uri);
    }

    public static boolean openLink(URI uri, boolean alertError) {
        OS.log("Trying to open link with default browser:", uri);
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable e) {
            OS.log("Failed to open link with default browser:", uri, e);
            if (alertError) {
                Alert.showLocError("ui.error.openlink", uri);
            }
            return false;
        }
        return true;
    }

    public static boolean openLink(URI uri) {
        return OS.openLink(uri, true);
    }

    public static boolean openLink(URL url, boolean alertError) {
        OS.log("Trying to open URL with default browser:", url);
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OS.openLink(uri, alertError);
    }

    public static boolean openLink(URL url) {
        return OS.openLink(url, true);
    }

    private static void openPath(File path, boolean appendSeparator) throws Throwable {
        String absPath = String.valueOf(path.getAbsolutePath()) + File.separatorChar;
        Runtime r = Runtime.getRuntime();
        Throwable t = null;
        switch (CURRENT) {
            case OSX: {
                String[] cmdArr = new String[]{"/usr/bin/open", absPath};
                try {
                    r.exec(cmdArr);
                    return;
                }
                catch (Throwable e) {
                    t = e;
                    OS.log("Cannot open folder using:\n", cmdArr, e);
                    break;
                }
            }
            case WINDOWS: {
                String cmd = String.format("cmd.exe /C start \"Open path\" \"%s\"", absPath);
                try {
                    r.exec(cmd);
                    return;
                }
                catch (Throwable e) {
                    t = e;
                    OS.log("Cannot open folder using CMD.exe:\n", cmd, e);
                    break;
                }
            }
            default: {
                OS.log("... will use desktop");
            }
        }
        try {
            OS.rawOpenLink(path.toURI());
        }
        catch (Throwable e) {
            t = e;
        }
        if (t == null) {
            return;
        }
        throw t;
    }

    public static boolean openFolder(File folder, boolean alertError) {
        OS.log("Trying to open folder:", folder);
        if (!folder.isDirectory()) {
            OS.log("This path is not a directory, sorry.");
            return false;
        }
        try {
            OS.openPath(folder, true);
        }
        catch (Throwable e) {
            OS.log("Failed to open folder:", e);
            if (alertError) {
                Alert.showLocError("ui.error.openfolder", folder);
            }
            return false;
        }
        return true;
    }

    public static boolean openFolder(File folder) {
        return OS.openFolder(folder, true);
    }

    public static boolean openFile(File file, boolean alertError) {
        OS.log("Trying to open file:", file);
        if (!file.isFile()) {
            OS.log("This path is not a file, sorry.");
            return false;
        }
        try {
            OS.openPath(file, false);
        }
        catch (Throwable e) {
            OS.log("Failed to open file:", e);
            if (alertError) {
                Alert.showLocError("ui.error.openfolder", file);
            }
            return false;
        }
        return true;
    }

    public static boolean openFile(File file) {
        return OS.openFile(file, true);
    }

    protected static void log(Object ... o) {
        U.log("[OS]", o);
    }

    public static enum Arch {
        x32,
        x64,
        UNKNOWN;

        public static final Arch CURRENT;
        public static final long TOTAL_RAM;
        public static final long TOTAL_RAM_MB;
        public static final int MIN_MEMORY = 512;
        public static final int PREFERRED_MEMORY;
        public static final int MAX_MEMORY;
        private final String asString = this.toString().substring(1);
        private final int asInt;

        static {
            CURRENT = Arch.getCurrent();
            TOTAL_RAM = Arch.getTotalRam();
            TOTAL_RAM_MB = TOTAL_RAM / 1024L / 1024L;
            PREFERRED_MEMORY = Arch.getPreferredMemory();
            MAX_MEMORY = Arch.getMaximumMemory();
        }

        private Arch() {
            int asInt_temp = 0;
            try {
                asInt_temp = Integer.parseInt(this.asString);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.asInt = asInt_temp;
        }

        public String asString() {
            return this == UNKNOWN ? this.toString() : this.asString;
        }

        public int asInteger() {
            return this.asInt;
        }

        public boolean isCurrent() {
            return this == CURRENT;
        }

        private static Arch getCurrent() {
            String curArch = System.getProperty("sun.arch.data.model");
            Arch[] archArray = Arch.values();
            int n = archArray.length;
            int n2 = 0;
            while (n2 < n) {
                Arch arch = archArray[n2];
                if (arch.asString.equals(curArch)) {
                    return arch;
                }
                ++n2;
            }
            return UNKNOWN;
        }

        private static long getTotalRam() {
            try {
                return ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
            }
            catch (Throwable e) {
                U.log("[ERROR] Cannot allocate total physical memory size!", e);
                return 0L;
            }
        }

        private static int getPreferredMemory() {
            switch (CURRENT) {
                case x32: {
                    if (TOTAL_RAM_MB > 4000L) {
                        return 1024;
                    }
                    return 512;
                }
                case x64: {
                    return 1024;
                }
            }
            return 512;
        }

        private static int getMaximumMemory() {
            switch (CURRENT) {
                case x32: {
                    if (TOTAL_RAM_MB > 4000L) {
                        return 1536;
                    }
                    return 1024;
                }
                case x64: {
                    if (TOTAL_RAM_MB > 6000L) {
                        return 3072;
                    }
                    if (TOTAL_RAM_MB > 3000L) {
                        return 1536;
                    }
                    return 1024;
                }
            }
            return 512;
        }
    }
}

