/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mickkay.scenter.CommonProxy;
import mickkay.scenter.client.BlockScanner;
import mickkay.scenter.client.KeyEventHandler;
import mickkay.scenter.client.ParticleTrailEffects;
import mickkay.scenter.client.PlayerEventHandler;
import mickkay.scenter.client.TickEventHandler;
import mickkay.scenter.config.Target;
import mickkay.scenter.config.TargetPart;
import mickkay.scenter.config.TargetsConfig;
import mickkay.scenter.net.ConfigMessage;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private ParticleTrailEffects particleTrailEffects = new ParticleTrailEffects();
    private static final String MINECRAFT_KEY_PREFIX = "minecraft:";
    private BlockScanner blockScanner;
    private List<Target> targets;
    private int targetIndex = 0;
    private double hudX;
    private double hudY;
    private boolean active = false;
    private boolean hasShownDisabledMessage = false;
    private boolean hasShownNoTargetsMessage = false;
    public Double distance = null;
    public long lastUpdate = 0L;

    @Override
    public void init(File standardConfigFile) throws Exception {
        super.init(standardConfigFile);
        this.blockScanner = new BlockScanner();
    }

    @Override
    protected void reloadConfiguration() throws IOException {
        super.reloadConfiguration();
        this.hudX = this.config.getHudX();
        this.hudY = this.config.getHudY();
        this.config.save();
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new TickEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new KeyEventHandler());
    }

    private void reset() {
        this.targets = null;
        this.targetIndex = 0;
        this.hasShownDisabledMessage = false;
        this.hasShownNoTargetsMessage = false;
        this.active = false;
        try {
            this.reloadConfiguration();
        }
        catch (Exception ex) {
            this.logger.error(String.format("Can't reload configuration", new Object[0]), (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void onMultiplayerServerMessage(ConfigMessage message) {
        this.reset();
        this.logger.info(String.format("Scenter %s is installed on this server", message.scenterVersionOnServer));
        this.showOnConsole("Scenter is using server-side configuration");
        this.setEnabled(message.scenterIsEnabledOnServer);
        this.setDetectionRadius(message.detectionRadius);
        this.loadTargetsConfigFromString(message.targetsConfigContent);
    }

    @Override
    public void onSingleplayerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        this.reset();
    }

    public double getHudX() {
        return this.hudX;
    }

    public double getHudY() {
        return this.hudY;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        if (!this.isEnabled()) {
            if (!this.hasShownDisabledMessage) {
                this.showOnConsole("Can't activate Scenter since it has been disabled on this server!");
                this.hasShownDisabledMessage = true;
            }
            return;
        }
        if (value == this.active) {
            return;
        }
        if (this.targets == null) {
            this.showAllKnownBlocks();
            if (!this.initializeTargets()) {
                return;
            }
            this.showAllConfiguredTargets();
        }
        if (value && this.targets.size() == 0) {
            if (!this.hasShownNoTargetsMessage) {
                this.showOnConsole("Can't activate Scenter since no targets have been configured on this server!");
                this.hasShownNoTargetsMessage = true;
            }
            return;
        }
        if (value) {
            this.blockScanner.setTarget(this.getTarget(this.targetIndex));
        }
        this.active = value;
        this.showOnConsole("Scenter is " + (this.active ? "active" : "inactive"));
        this.findOres();
    }

    private boolean initializeTargets() {
        try {
            this.targets = this.config.getTargets();
            this.targetIndex = 0;
            return true;
        }
        catch (RuntimeException e) {
            this.showOnConsole("Scenter can't read targets configuration: " + e.getMessage());
            this.logger.error("Scenter can't read targets configuration", (Throwable)e);
            return false;
        }
    }

    private void showAllKnownBlocks() {
        this.logger.info("Showing all registered blocks...");
        Set keys = Block.field_149771_c.func_148742_b();
        LinkedList<String> listOfKeys = new LinkedList<String>();
        for (Object key : keys) {
            listOfKeys.add(String.valueOf(key));
        }
        this.logBlockNames("These blocks are registered:", listOfKeys);
    }

    private void showAllConfiguredTargets() {
        if (this.targets == null) {
            this.logger.info("No targets have been configured!");
            return;
        }
        HashSet names = Sets.newHashSet();
        for (Target t : this.targets) {
            for (TargetPart part : t.getParts()) {
                String name = String.valueOf(Block.field_149771_c.func_177774_c((Object)part.block));
                names.add(name);
            }
        }
        this.logBlockNames("These targets have been configured:", Lists.newArrayList((Iterable)names));
    }

    private void logBlockNames(String prefix, List<String> listOfKeys) {
        if (listOfKeys == null || listOfKeys.isEmpty()) {
            this.logger.info(prefix + " <none>");
            return;
        }
        Collections.sort(listOfKeys);
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        builder.append(String.format("%n", new Object[0]));
        for (String key : listOfKeys) {
            if (key.startsWith(MINECRAFT_KEY_PREFIX)) {
                key = key.substring(MINECRAFT_KEY_PREFIX.length());
            }
            builder.append(key).append(String.format("%n", new Object[0]));
        }
        this.logger.info(builder.toString());
    }

    public void nextBlockType() {
        this.targetIndex = (this.targetIndex + 1) % this.targets.size();
        this.blockScanner.setTarget(this.getTarget(this.targetIndex));
        this.findOres();
    }

    private Target getTarget(int index) {
        if (this.targets.size() <= index) {
            return null;
        }
        Target target = this.targets.get(index);
        return target;
    }

    private void findOres() {
        if (!this.active) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        this.findOres((EntityPlayer)player);
    }

    public boolean findOres(EntityPlayer p) {
        if (!this.active) {
            return false;
        }
        double dy = 1.5;
        double minDist = this.blockScanner.scan(p.field_70170_p, p.field_70176_ah, p.field_70164_aj, (int)p.field_70165_t, (int)p.field_70163_u + (int)dy + 1, (int)p.field_70161_v);
        if (minDist < Double.MAX_VALUE) {
            double fromX = p.field_70165_t;
            double fromY = p.field_70163_u;
            double fromZ = p.field_70161_v;
            Color color = this.blockScanner.getTargetColor();
            this.spawnParticleTrail(p.field_70170_p, fromX, fromY + dy, fromZ, this.blockScanner.getFoundX(), this.blockScanner.getFoundY(), this.blockScanner.getFoundZ(), color);
            this.distance = minDist;
            this.lastUpdate = System.currentTimeMillis();
            return true;
        }
        this.distance = null;
        this.lastUpdate = System.currentTimeMillis();
        return false;
    }

    private void spawnParticleTrail(World worldObj, double fromX, double fromY, double fromZ, double toX, double toY, double toZ, Color color) {
        this.particleTrailEffects.spawnParticleTrail(worldObj, fromX, fromY, fromZ, toX, toY, toZ, color);
    }

    public ItemStack getTargetItemStack() {
        return this.blockScanner.getTargetPart().itemStack;
    }

    public String getTargetDisplayName() {
        TargetPart targetPart = this.blockScanner.getTargetPart();
        return this.getDisplayName(targetPart);
    }

    private String getDisplayName(TargetPart targetPart) {
        String displayName = targetPart.getDisplayName();
        if (displayName == null || displayName.trim().length() == 0) {
            displayName = String.valueOf(Block.field_149771_c.func_177774_c((Object)targetPart.block));
        }
        return displayName;
    }

    private synchronized void showOnConsole(String msg) {
        if (FMLClientHandler.instance().getClient() != null && FMLClientHandler.instance().getClient().field_71439_g != null) {
            FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }

    private void loadTargetsConfigFromString(String targetsConfigContent) {
        if (targetsConfigContent != null) {
            try {
                TargetsConfig targetsConfig = new TargetsConfig();
                targetsConfig.load(new StringReader(targetsConfigContent));
                this.config.setTargetsConfig(targetsConfig);
            }
            catch (IOException e) {
                this.showOnConsole("Scenter can't read server's targets configuration: " + e.getMessage());
                this.logger.error("Scenter can't read server's targets configuration", (Throwable)e);
                this.setEnabled(false);
            }
        }
    }
}

