/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.client;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityAuraFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleTrailEffects {
    private final Minecraft minecraft = FMLClientHandler.instance().getClient();
    private final float[] colorComponents = new float[3];
    private final EntityAuraFX.Factory factory = new EntityAuraFX.Factory();

    public void spawnParticleTrail(World worldObj, double fromX, double fromY, double fromZ, double toX, double toY, double toZ, Color color) {
        this.spawnSingleParticle(worldObj, 0.5 + toX, 0.5 + toY, 0.5 + toZ, 1.0f, color, 0.0, 0.0, 0.0);
        this.intSpawnParticleTrail(worldObj, fromX, fromY, fromZ, toX + 0.5, toY + 0.5, toZ + 0.5, color);
    }

    private void intSpawnParticleTrail(World theWorld, double fromX, double fromY, double fromZ, double toX, double toY, double toZ, Color color) {
        double dx = toX - fromX;
        double dy = toY - fromY;
        double dz = toZ - fromZ;
        double steps = Math.max(Math.abs(dx), Math.max(Math.abs(dy), Math.abs(dz))) * 3.0;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double strength = 0.5;
        double ds = strength / 30.0;
        double vx = dx / dist * 0.015;
        double vy = dy / dist * 0.015;
        double vz = dz / dist * 0.015;
        int i = 0;
        while ((double)i < steps) {
            double x = fromX + dx / steps * (double)i;
            double y = fromY + dy / steps * (double)i;
            double z = fromZ + dz / steps * (double)i;
            if ((strength -= ds) < 0.2) {
                strength = 0.2;
            }
            this.spawnSingleParticle(theWorld, x, y, z, (float)strength, color, vx, vy, vz);
            ++i;
        }
    }

    private void spawnSingleParticle(World theWorld, double x, double y, double z, float alpha, Color color, double vx, double vy, double vz) {
        int unused = 0;
        EntityFX effect = this.factory.func_178902_a(unused, theWorld, x, y, z, vx, vy, vz, new int[0]);
        effect.func_70536_a(147);
        color.getColorComponents(this.colorComponents);
        effect.func_70538_b(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2]);
        effect.func_82338_g(alpha);
        effect.func_70016_h(vx, vy, vz);
        this.minecraft.field_71452_i.func_78873_a(effect);
    }
}

