/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.helper;

import de.eydamos.backpack.saves.BackpackSave;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryHelper {
    public static void readInventory(BackpackSave backpackSave, String name, ItemStack[] inventory) {
        InventoryHelper.readInventory(backpackSave, name, inventory, true);
    }

    public static void readInventory(BackpackSave backpackSave, String inventoryName, ItemStack[] inventory, boolean clearInventory) {
        if (clearInventory) {
            for (int i = 0; i < inventory.length; ++i) {
                inventory[i] = null;
            }
        }
        NBTTagList inventoryList = backpackSave.getInventory(inventoryName);
        for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = inventoryList.func_150305_b(i);
            int slot = slotEntry.func_74771_c("slot") & 0xFF;
            if (slot < 0 || slot >= inventory.length) continue;
            inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)slotEntry);
        }
    }

    public static void writeInventory(BackpackSave backpackSave, String inventoryName, ItemStack[] inventory) {
        NBTTagList inventoryList = new NBTTagList();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("slot", (byte)i);
            inventory[i].func_77955_b(slotEntry);
            inventoryList.func_74742_a((NBTBase)slotEntry);
        }
        backpackSave.setInventory(inventoryName, inventoryList);
    }
}

