/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.saves;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.saves.AbstractSave;
import de.eydamos.backpack.util.BackpackUtil;
import de.eydamos.backpack.util.NBTUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerSave
extends AbstractSave {
    protected byte type;

    public PlayerSave(String uuid) {
        super(uuid);
    }

    public PlayerSave(NBTTagCompound data) {
        super(data);
    }

    public PlayerSave(EntityPlayer entityPlayer) {
        this(new NBTTagCompound());
        this.load(entityPlayer.func_110124_au().toString());
    }

    public String getPersonalBackpackOpen() {
        return NBTUtil.getString(this.nbtTagCompound, "personalBackpackOpen");
    }

    public void setPersonalBackpackOpen(String backpackUUID) {
        NBTUtil.setString(this.nbtTagCompound, "personalBackpackOpen", backpackUUID);
        if (!this.manualSaving) {
            this.save();
        }
    }

    public void unsetPersonalBackpackOpen() {
        NBTUtil.removeTag(this.nbtTagCompound, "personalBackpackOpen");
        if (!this.manualSaving) {
            this.save();
        }
    }

    public boolean hasPersonalBackpack() {
        return NBTUtil.hasTag(this.nbtTagCompound, "personalBackpack");
    }

    public ItemStack getPersonalBackpack() {
        if (NBTUtil.hasTag(this.nbtTagCompound, "personalBackpack")) {
            return ItemStack.func_77949_a((NBTTagCompound)NBTUtil.getCompoundTag(this.nbtTagCompound, "personalBackpack"));
        }
        return null;
    }

    public void setPersonalBackpack(ItemStack itemStack) {
        if (itemStack == null) {
            NBTUtil.removeTag(this.nbtTagCompound, "personalBackpack");
        } else {
            NBTTagCompound backpack = new NBTTagCompound();
            itemStack.func_77955_b(backpack);
            NBTUtil.setCompoundTag(this.nbtTagCompound, "personalBackpack", backpack);
        }
        if (!this.manualSaving) {
            this.save();
        }
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public void setType(byte value) {
        this.type = value;
    }

    @Override
    public void save() {
        if (this.UID != null && BackpackUtil.isServerSide()) {
            Backpack.saveFileHandler.savePlayer(this.nbtTagCompound, this.UID);
        }
        this.manualSaving = false;
    }

    @Override
    protected void load(String UUID2) {
        if (UUID2 != null && BackpackUtil.isServerSide()) {
            this.UID = UUID2;
            this.nbtTagCompound = Backpack.saveFileHandler.loadPlayer(this.UID);
        }
    }
}

