/*
 * Decompiled with CFR 0.152.
 */
package firehazurd.qcreatures.entity.passive;

import firehazurd.qcreatures.entity.ai.EntityAITortoiseFollow;
import firehazurd.qcreatures.init.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class EntityTortoise
extends EntityAnimal {
    public AnimalChest tortoiseChest;
    public int happiness;

    public EntityTortoise(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.2f, 1.2f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITortoiseFollow(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.tortoiseChest = new AnimalChest("TortoiseChest", 54);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.24);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.happiness > 0 && this.field_70146_Z.nextInt(50) == 0) {
            --this.happiness;
        }
    }

    private boolean getTortoiseWatchableBoolean(int i) {
        return (this.field_70180_af.func_75679_c(16) & i) != 0;
    }

    private void setTortoiseWatchableBoolean(int i, boolean flag) {
        int j = this.field_70180_af.func_75679_c(16);
        if (flag) {
            this.field_70180_af.func_75692_b(16, (Object)(j | i));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)(j & ~i));
        }
    }

    public boolean isTortoiseChested() {
        return this.getTortoiseWatchableBoolean(2);
    }

    public void setTortoiseChested(boolean chested) {
        this.setTortoiseWatchableBoolean(2, chested);
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return "qcreatures:mob.tortoise.hurt";
    }

    protected String func_70673_aS() {
        return "qcreatures:mob.tortoise.death";
    }

    protected void func_70628_a(boolean recent, int looting) {
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_145779_a(ModItems.shell, 1);
        }
        if (this.isTortoiseChested()) {
            for (int i = 0; i < this.tortoiseChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.tortoiseChest.func_70301_a(i);
                if (itemstack == null) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
            this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150486_ae), 1);
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Chested", this.isTortoiseChested());
        tagCompound.func_74768_a("Happiness", this.happiness);
        if (this.isTortoiseChested()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.tortoiseChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.tortoiseChest.func_70301_a(i);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            tagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setTortoiseChested(tagCompound.func_74767_n("Chested"));
        this.happiness = tagCompound.func_74762_e("Happiness");
        if (this.isTortoiseChested()) {
            NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j >= this.tortoiseChest.func_70302_i_()) continue;
                this.tortoiseChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void openTortoiseGui(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.tortoiseChest.func_110133_a(this.func_70005_c_());
            player.func_71007_a((IInventory)this.tortoiseChest);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && this.isTortoiseFood(itemstack.func_77973_b())) {
            this.func_175505_a(player, itemstack);
            this.func_85030_a("qcreatures:mob.tortoise.eating", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.happiness += 25;
            if (this.happiness > 100) {
                this.happiness = 100;
            }
            this.func_70691_i(1.0f);
            return true;
        }
        if (this.isTortoiseChested()) {
            this.openTortoiseGui(player);
            return true;
        }
        if (this.happiness > 0 && itemstack != null && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            this.func_175505_a(player, itemstack);
            this.setTortoiseChested(true);
            this.func_85030_a("mob.chicken.plop", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            return true;
        }
        return super.func_70085_c(player);
    }

    public boolean isTortoiseFood(Item item) {
        return item == Item.func_150898_a((Block)Blocks.field_150327_N) || item == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityTortoise(this.field_70170_p);
    }
}

